/*************************************************************
 *  $Id: init.c,v 1.4 91/05/17 12:10:56 dhay Exp $
 *
 *  init.c
 *
 *  Initialize any global data that need init'ing.
 */
/*******************************************************
 *  Copyright (C) Doug Hay, 1989,90,91.
 *  Permission to use and abuse this code, as long
 *  as this copyright notice stays intact and with the
 *  code.  No warranty implied.  This code supplied as is.
 *******************************************************/

#include <stdio.h>
#include "cntl.h"
#include "data.h"

/* From print.c */
void prt();

static int showinit;
static void set_user_info();

/****************************************
 * string_env
 *
 * Look for the specified environment var.
 * If it doesn't exist, use the default.
 * Return 0 if default used, 1 if env used.
 */ 
    static int
string_env(whr, env, def, max)
    char *whr, *env, *def;
    int max;
{
    int l;
    char *ep;
    char *getenv(), *strncpy(), *strcpy();

    if ((ep=getenv(env))) {
	l = strlen(ep);
	if (l >= max)
	    l = max - 1;
	(void) strncpy(whr, ep, l);
    } else {
	l = strlen(def);
	if (l >= max)
	    l = max - 1;
	(void) strcpy(whr, def);
    }
    if (showinit)
	prt(" def: %s   env: %s   set: %s\n",
		def, env, whr);
    return((ep != NULL));
}

    void
set_defaults()
{
    char *getenv(), *strcpy(), *strcat();

    set_user_info();
    cntl.pid = getpid();

    if (getenv("EIFSHOWINIT"))
	showinit = 1;


    if (!string_env(cntl.st.startupf, "EIFSTARTF", "",
		sizeof(cntl.st.startupf))) {
	if (cntl.usr.homedir &&
			(strlen(cntl.usr.homedir)+8) <=
				sizeof(cntl.st.startupf)) {
	    (void) strcpy(cntl.st.startupf, cntl.usr.homedir);
	    (void) strcat(cntl.st.startupf, "/.eifrc");
	    cntl.st.readstartup = 1;
	} else
	    cntl.st.readstartup = 0;
    } else
	cntl.st.readstartup = 1;
}

#include <pwd.h>
    static void
set_user_info()
{
    struct passwd *pwd;
    char *malloc(), *strcpy();

    cntl.usr.uid = getuid();
    pwd = getpwuid(cntl.usr.uid);
    if (pwd) {
	cntl.usr.name = malloc((unsigned)strlen(pwd->pw_name) + 1);
	(void) strcpy(cntl.usr.name, pwd->pw_name);
	cntl.usr.homedir = malloc((unsigned)strlen(pwd->pw_dir) + 1);
	(void) strcpy(cntl.usr.homedir, pwd->pw_dir);
	cntl.usr.shell = malloc((unsigned)strlen(pwd->pw_shell) + 1);
	(void) strcpy(cntl.usr.shell, pwd->pw_shell);
    }
}
