/*************************************************************
 *  $Id: empcon.c,v 1.5 91/05/17 12:10:50 dhay Exp $
 *
 *  empcon.c
 *
 */
/*******************************************************
 *  Copyright (C) Doug Hay, 1991.
 *  Permission to use and abuse this code, as long
 *  as this copyright notice stays intact and with the
 *  code.  No warranty implied.  This code supplied as is.
 *******************************************************/

#include <stdio.h>
#include "cntl.h"
#include "data.h"
#include <ctype.h>

/* In print.c */
void prt(), eprt();

/* In games.c */
void game_died(), switch_gameout();
int switch_to(), add_game();

/* In connect/connect.c */
int empire_connect();

/* In connect/sock.c */
int readsock();

/* Local */
static char *next_online();

/******************************************
 * cmd_connect
 */
    void
cmd_connect(buf, sub)
    char *buf;
    int sub;
{
    int kill_it=0;
    int sock;
    char nameb[20];

    /* We are doing a kill, rather than a connect */
    if (sub == 1) kill_it = 1;

    /* Parse or ask for the game name */
    if (!next_online(buf, nameb, sizeof(nameb), "Game name? ",
			 "Bad game name."))
	return;

    /* Switch into that game's context. */
    if (!switch_to(nameb))
	return;

    /* If we aren't already connected */
    if (-1 == game_socket) {
	if ((sock=empire_connect(game_host, game_port, game_country, game_rep,
			kill_it)) != -1) {
	    eprt("Connected!\n");
	    game_socket = sock;
	    game_time = 0;
	    game_btus = 0;
	    if (-1 == readsock(sock, stdout, 20, (char *) 0, 0))
		game_died();
	} else {
	    if (!kill_it)
		eprt("Connection failed.\n");
	    game_died();
	}
    } else
	eprt("Reconnected.\n");
}

/******************************************
 * cmd_try
 */
    void
cmd_try(buf, sub)
    char *buf;
    int sub;
{
    int kill_it = 0;
    int sock;
    char nameb[20];
    char coun[20];
    char rep[20];

    if (sub == 1) kill_it = 1;

    if (!(buf=next_online(buf, nameb, sizeof(nameb), "Game name? ",
			 "Bad game name.")))
	return;

    if (!switch_to(nameb))
	return;

    if (!(buf=next_online(buf, coun, sizeof(coun), "Country? ",
			 "Bad country.")))
	return;

    if (!(buf=next_online(buf, rep, sizeof(rep), "Rep? ",
			 "Bad rep.")))
	return;

    /* Make sure close an existing connection */
    if (-1 != game_socket) {
	close(game_socket);
	game_socket = -1;
    }

    /* Try it. */
    if ((sock=empire_connect(game_host, game_port, coun, rep, kill_it))
			!= -1) {
	eprt("Connected!\n");
	game_socket = sock;
	game_time = 0;
	game_btus = 0;
	if (-1 == readsock(sock, stdout, 20, (char *) 0, 0))
	    game_died();
    } else {
	if (!kill_it)
	    eprt("Connection failed.\n");
	game_died();
    }
}

/******************************************
 * game_died
 */
    void
game_died()
{
    void switch_gameout();

    if (-1 != game_socket) {
	eprt("Game died.\n");
	close(game_socket);
	game_socket = -1;
	switch_gameout();
    }
}

/******************************************
 * next_online
 *
 * Parse a command line for an option, and if it
 * doesn't exist, ask the user for it.
 *
 * Allows quoted strings.
 */
    static char *
next_online(cmd, where, len, prompt, erm)
    char *cmd, *where, *prompt, *erm;
    int len;
{
    char *cp;
    char *strcpy();

    while (isspace(*cmd)) cmd++;
    if (*cmd) {
	cp = cmd;
	if ('"' == *cp) {
	    cp++;
	    while (*cmd && '"' != *cmd) cmd++;
	    if ('"' != *cmd) {
		eprt("Missing end \".  %s\n", erm);
		return((char *) 0);
	    }
	} else
	    while (*cmd && !isspace(*cmd)) cmd++;
	if (*cmd)
	    *cmd++ = '\0';
	if (strlen(cp) >= len) {
	    eprt("Too long.  %s\n", erm);
	    return((char *) 0);
	}
	(void)strcpy(where, cp);
    } else {
	if (!get_input(where, len, prompt))
	    return((char *) 0);
	if (!*where) {
	    eprt("%s\n", erm);
	    return((char *) 0);
	}
    }
    return(cmd);
}

/******************************************
 * cmd_addgame
 */
    void
cmd_addgame(cmd, sub)
    char *cmd;
    int sub;
{
    char nameb[20], hostb[40], portb[8], counb[20], repb[10], datafb[50];
    int xsize, ysize, proto, wait;

    if (!(cmd=next_online(cmd, nameb, sizeof(nameb), "Game name? ",
			 "Bad game name.")))
	return;
    if (!(cmd=next_online(cmd, hostb, sizeof(hostb), "Host name or address? ",
			 "Bad host name.")))
	return;
    if (!(cmd=next_online(cmd, portb, sizeof(portb), "Game port? ",
			 "Bad game port.")))
	return;
    if (!(cmd=next_online(cmd, counb, sizeof(counb), "Country name? ",
			 "Bad country name.")))
	return;
    if (!(cmd=next_online(cmd, repb, sizeof(repb), "Representative? ",
			 "Bad representative.")))
	return;
    if (!(cmd=next_online(cmd, datafb, sizeof(datafb), "Data file name? ",
			 "Bad datafile name.")))
	return;

    /* Currently, the only useful option is wait. */
    xsize = 64;
    ysize = 32;
    proto = 1;
    wait = 120;

    if (!add_game(nameb, hostb, portb, counb, repb, xsize, ysize, proto,
		wait, datafb)) {
	eprt("Add of country failed.\n");
    } else
	prt("Game %s added.\n", nameb);
}
