#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/map.c,v 2.2 1995/07/27 00:10:14 empire Exp $";
#endif /* not lint */

/*
 * map.c
 *
 * empire map: probably the most-used command in empire.
 *
 * Dave Pare, 1986
 *
 * Significant rewrite, moving subroutines into subs/maps.c
 * Ken Stevens, 1995
 */

#include "misc.h"
#include "nat.h"
#include "file.h"
#include "player.h"
#include "map.h"
#include "ship.h"
#include "land.h"
#include "plane.h"
#include "xy.h"
#include "nsc.h"

map()
{
	register s_char *b;
	int	unit_type = 0;
	int	bmap = 0;
	struct	natstr *np;
	s_char	*str;
	struct	nstr_sect ns;
	s_char  origin = '\0';
	int	as_country;
	int     map_flags = 0;
	int	i;
	int     where = 2;
	s_char	what[64];
	s_char buf[1024];

	if (**player->argp != 'm') {
		if (**player->argp == 'b')
			bmap = EF_BMAP;
		else {
			if (**player->argp == 'l')
				unit_type = EF_LAND;
			else if (**player->argp == 'p')
				unit_type = EF_PLANE;
			else if (**player->argp == 's')
				unit_type = EF_SHIP;
			else {
				logerror("map: bad player->argp[0]");
				return RET_SYN;
			}
			if (player->argp[0][1] == 'b')
				bmap = EF_BMAP;
		}
	}

	if (player->argp[1] == (s_char *) 0) {
		if ((str = getstring("(sects)? ", buf)) == 0)
			return RET_SYN;
	} else {
		str = player->argp[1];
	}

	np = getnatp(player->cnum);
	if (*str == '*') {
		sprintf(what, "%d:%d,%d:%d",
			-WORLD_X/2, WORLD_X/2-1,
			-WORLD_Y/2, WORLD_Y/2-1);
		if (!snxtsct(&ns, what))
			return RET_FAIL;
	} else if (!snxtsct(&ns, str)) {
		i=atoi(str);
		if (unit_map(unit_type, i, &ns, &origin))
			return RET_FAIL;
	}
	b = player->argp[2];
	while (b != (s_char *)0 && (*b)){
		where = 3;
		switch(*b){
			case 's':
			case 'S':	map_flags |= MAP_SHIP; break;
			case 'l':
			case 'L':	map_flags |= MAP_LAND; break;
			case 'p':
			case 'P':	map_flags |= MAP_PLANE; break;
			case '*':	map_flags |= MAP_ALL; 	break;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	where = 2; break;
			case 't':	bmap = EF_MAP; *(b+1)=0;break;
			case 'r':	bmap = EF_MAP + EF_BMAP;*(b+1)=0;break;
			default:	pr("Bad flag %c!\n",*b);
					break;
		}
		b++;
	}

	as_country = player->cnum;
	if (player->god){
                if (player->argp[where] != (s_char *) 0) {
                        as_country=atoi(player->argp[where]);
			if ((as_country < 0) || (as_country > MAXNOC)){
				as_country = player->cnum;
			}
		}
	}

	return draw_map(bmap, origin, map_flags, &ns, as_country);
}
