#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/news.c,v 2.11 1995/10/24 04:39:16 empire Exp $";
#endif /* not lint */

/*
 * news
 *
 * Show the current empire news
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "nat.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"
#ifdef HIDDEN
#include "deity.h"
#endif /* HIDDEN */

static	void preport();

news()
{
	extern	s_char *page_headings[];
	struct	natstr *natp;
	long	now;
	int	page;
	time_t	then;
	long	delta;
	struct	nwsstr nws;
	struct	nstr_item nstr;
	int	page_has_news[N_MAX_PAGE+1];
	int	there_is_news = 0;
	short	sectors_taken[MAXNOC][MAXNOC];
	short	sectors_delta;
	short	max_delta = -1;
	short	abs_delta;
	short	k;
	int	sectors_were_taken = 0;
	natid	i,j;
	s_char	num[128];
	s_char	*verb;

	bzero(page_has_news, sizeof(page_has_news));
	bzero(sectors_taken, sizeof(sectors_taken));
	(void) head();
	(void) time(&now);
	natp = getnatp(player->cnum);
#ifndef HIDDEN
	if (player->argp[1] != 0 && isdigit(*player->argp[1])) {
		delta = days(atoi(player->argp[1]));
		then = now - delta;
	} else
#endif /* HIDDEN */
		then = natp->nat_newstim;
	natp->nat_newstim = now;
/*	if (then < now - days(3))
		then = now - days(3);
*/
	snxtitem(&nstr, EF_NEWS, "*");
	pr("\nThe details of Empire news since %s", ctime(&then));
	while (nxtitem(&nstr, (s_char *)&nws)) {
		if (nws.nws_when < then)
			continue;
#ifdef HIDDEN
			if (!player->god && !(getcontact(getnatp(nws.nws_ano), player->cnum) && getcontact(getnatp(nws.nws_vno), player->cnum)))
				continue;
#endif /* HIDDEN */
		++page_has_news[rpt[nws.nws_vrb].r_newspage];
		++there_is_news;
	}
	for (page = 1; page <= N_MAX_PAGE; page++) {
		if (!page_has_news[page])
			continue;
		pr("\n\t ===  %s  ===\n", page_headings[page]);
		snxtitem_rewind(&nstr);
		while (nxtitem(&nstr, (s_char *)&nws)) {
			if (rpt[nws.nws_vrb].r_newspage != page)
				continue;
			if (nws.nws_when < then)
				continue;
			if (nws.nws_ntm == 0)
				nws.nws_ntm = 1;
#ifdef HIDDEN
			if (!player->god && !(getcontact(getnatp(nws.nws_ano), player->cnum) && getcontact(getnatp(nws.nws_vno), player->cnum)))
				continue;
#endif /* HIDDEN */
			if (page == N_FRONT &&
			    (nws.nws_vrb == N_WON_SECT ||
			     nws.nws_vrb == N_AWON_SECT ||
			     nws.nws_vrb == N_PWON_SECT)) {
				sectors_taken[nws.nws_ano][nws.nws_vno] += nws.nws_ntm;
				sectors_were_taken += nws.nws_ntm;
			}
			preport(&nws);
		}
	}
	if (sectors_were_taken) {
		for (i = 0; i < MAXNOC; ++i) {
			for (j = 0; j < i; ++j) {
				sectors_delta = sectors_taken[i][j] -
						sectors_taken[j][i];
				if (max_delta < abs(sectors_delta))
					max_delta = abs(sectors_delta);
			}
		}
		pr("\n\t ===  The Bottom Line   ==\n");
		for (k = max_delta; k > 0; --k) {
			for (i = 0; i < MAXNOC; ++i) {
				for (j = 0; j < i; ++j) {
					sectors_delta = sectors_taken[i][j] -
						sectors_taken[j][i];
					abs_delta = abs(sectors_delta);
					if (abs_delta != k)
						continue;
					if (abs_delta == 1)
						verb = "stole";
					else if (abs_delta < 4)
						verb = "took";
					else if (abs_delta < 8)
						verb = "captured";
					else
						verb = "seized";
					if (sectors_delta > 0) {
						numstr(num, abs_delta);
						pr("%s %s %s sector%s from %s\n", cname(i), verb, num, splur(sectors_delta), cname(j));
					} else if (sectors_delta < 0) {
						numstr(num, abs_delta);
						pr("%s %s %s sector%s from %s\n", cname(j), verb, num, splur(-sectors_delta), cname(i));
					}
				}
			}
		}
	}
	if (!there_is_news)
		pr("\nNo news at the moment...\n");
	return 0;
}

static void
preport(np)
	register struct nwsstr *np;
{
	register s_char *cp;
	register int i;
	s_char	buf[255];
	s_char	num[128];
	s_char	*ptr;

	cp = buf;
	sprintf(buf, "%-16.16s  ", ctime(&np->nws_when));
	cp += strlen(cp);
	ptr = numstr(num, np->nws_ntm);
	/*
	 * vary the order of the printing of "%d times "
	 */
	if ((random() & 3) == 0 && np->nws_ntm > 1) {
		sprintf(cp, "%s times ", ptr);
		cp += strlen(cp);
		np->nws_ntm = 1;
	}
	strcpy(cp, cname(np->nws_ano));
	cp += strlen(cp);
	*cp++ = ' ';
	if (np->nws_vrb < 1 || np->nws_vrb > N_MAX_VERB)
		np->nws_vrb = 0;
	sprintf(cp, rpt[np->nws_vrb].r_newstory[random() % NUM_RPTS],
		cname(np->nws_vno));
	cp += strlen(cp);
	if (np->nws_ntm != 1) {
		sprintf(cp, " %s times", ptr);
		cp += strlen(cp);
	}
	if (*buf >= 'a' && *buf <= 'z')
		*buf += 'A' - 'a';
	if (cp - buf > 80) {
		for (i=80; --i > 60; )
			if (buf[i] == ' ') break;
		buf[i] = '\0';
		pr("%s\n\t\t  %s\n", buf, &buf[i+1]);
	} else {
		pr("%s\n", buf);
	}
	np->nws_ntm = 0;
	return;
}
