#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/update/prepare.c,v 2.8 1995/10/11 03:05:54 empire Exp $";
#endif

/*
 * prepare.c
 *
 * perform preliminary updates of the sect
 *
 * Does this for all countries at once
 * 
 * Modified from code
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 *
 * by Thomas Ruschak, 1992
 */

#include <math.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "item.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#ifdef	FALLOUT
#include "path.h"
#endif	/* FALLOUT */
#include "optlist.h"
#include "budg.h"

extern	float levels[MAXNOC][4];
extern  int update_pending;
extern  double money_res;

void populace();
void tax();

prepare_sects(etu, bp)
	int	etu;
        int     *bp;
{
	extern	long pops[];
	register struct sctstr *sp;
	struct	natstr *np;
	int	n, civ_tax, uw_tax, mil_pay;

	bzero((s_char *)levels, sizeof(levels));

	for (n=0; sp = getsectid(n); n++) {
		sp->sct_updated = 0;

#ifdef	FALLOUT
	        do_fallout(sp,etu);
#endif	/* FALLOUT */

		if (sp->sct_type == SCT_WATER)
			continue;
		fill_update_array(bp, sp);
		np = getnatp(sp->sct_own);

#ifdef DEBUG
                if (np->nat_stat & STAT_SANCT)
		   logerror("Prepare.c: country in sanctuary skipped production");
#endif  /* DEBUG */

                if (!(np->nat_stat & STAT_SANCT)){
  	 	  guerrilla(sp);
		  do_plague(sp, np, etu);
		  tax(sp, np, etu, &pops[sp->sct_own], &civ_tax, &uw_tax, &mil_pay);
		  np->nat_money += civ_tax + uw_tax + mil_pay;
		  if (sp->sct_type == SCT_BANK)
		    np->nat_money += bank_income(sp, etu);
		  np->nat_money += (int) (np->nat_reserve * money_res * etu);
		}
	}
}

void
tax(sp, np, etu, pop, civ_tax, uw_tax, mil_pay)
struct  sctstr *sp;
struct  natstr *np;
int     etu, *pop, *civ_tax, *uw_tax, *mil_pay;
{
        int     vec[I_MAX+1];
	extern  double money_civ, money_mil, money_uw; 

	if (getvec(VT_ITEM, vec, (s_char *)sp, EF_SECTOR) <= 0)
	  return;

	if (update_pending)
	  populace(np, sp, vec, etu);
	*civ_tax = (int)(0.5 + vec[I_CIVIL] * sp->sct_effic * 
                     etu * money_civ / 100);
	*uw_tax = (int)(0.5 + vec[I_UW] * sp->sct_effic *
		     etu * money_uw / 100);
	*mil_pay = vec[I_MILIT] * etu * money_mil;

	/*
	 * only non-captured civs add to census for nation
	 */
	if (sp->sct_oldown == sp->sct_own)
		*pop += vec[I_CIVIL];
}

int
bank_income(sp, etu)
struct  sctstr *sp;
int     etu;
{
  extern  double bankint;
  int     vec[I_MAX+1];

  if (getvec(VT_ITEM, vec, (s_char *)sp, EF_SECTOR) <= 0)
    return 0;
  else
    return (int)(vec[I_BAR] * etu * bankint * sp->sct_effic / 100);
}
