#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/update/plague.c,v 1.0 1996/01/18 05:51:24 empire Exp $";
#endif

/*
 * plague.c
 *
 * Plague related functions collected from human.c, prepare.c etc.
 * 
 */

#include <math.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "item.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "optlist.h"

void
do_plague(sp,np,etu)
struct  sctstr *sp;
struct  natstr *np;
int     etu;
{
        int     vec[I_MAX+1];
	int     cvec[I_MAX+1];
	int     n;

	if (getvec(VT_ITEM, vec, (s_char *)sp, EF_SECTOR) <= 0)
	  return;
	if (getvec(VT_COND, cvec, (s_char *)sp, EF_SECTOR) <= 0)
	  bzero(cvec, sizeof(cvec));

	if (cvec[C_PSTAGE] == 0) {
		cvec[C_PSTAGE] = infect_people(np, vec, sp->sct_effic,
			(int)sp->sct_mobil);
		cvec[C_PTIME] = 0;
	} else {
		n = plague_people(np, vec, cvec, etu);
		switch (n) {
		case PLG_DYING:
			wu(0, sp->sct_own, "PLAGUE deaths reported in %s.\n",
				ownxy(sp));
			nreport(sp->sct_own, N_DIE_PLAGUE, 0, 1);
			break;
		case PLG_INFECT:
			wu(0, sp->sct_own, "%s battling PLAGUE\n", ownxy(sp));
			break;
		case PLG_INCUBATE:
			/* plage has moved into "infectious" stage */
			if (n != cvec[C_PSTAGE]) {
				wu(0, sp->sct_own,
					"Outbreak of PLAGUE in %s!\n",
					ownxy(sp));
				nreport(sp->sct_own, N_OUT_PLAGUE, 0, 1);
			}
			break;
		case PLG_EXPOSED:
		default:
			break;
		}
	}
	if (vec[I_CIVIL] == 0 && vec[I_MILIT] == 0 &&
		!has_units(sp->sct_x,sp->sct_y,sp->sct_own)) {
		sp->sct_own = 0;
		sp->sct_oldown = 0;
	}
	putvec(VT_ITEM, vec, (s_char *)sp, EF_SECTOR);
	putvec(VT_COND, cvec, (s_char *)sp, EF_SECTOR);
}

/*ARGSUSED*/
int
infect_people(np, vec, eff, mobil)
	struct	natstr *np;
	register int *vec;
	u_int	eff;
	int	mobil;
{
	double	plg_num;
	double	plg_denom;
	double	plg_chance;

	if (opt_NO_PLAGUE)	/* no plague nothing to do */
		return 0;

	if (np->nat_level[NAT_TLEV] <= 10.0)
		return 0;
	/*
	 * make plague where there was none before...
	 */
	plg_num = ((vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW]) / 999.0) *
		((vec[I_IRON] + vec[I_OIL]) / 10.0 +
		np->nat_level[NAT_TLEV] + 100.0);
	plg_denom = eff + mobil + 100 + np->nat_level[NAT_RLEV];
	plg_chance = ((plg_num / plg_denom) - 1.0) * 0.01;
	if (chance(plg_chance))
		return PLG_EXPOSED;
	return 0;
}

/*
 * Given the fact that plague exists, kill off
 * people if in plague state DYING.  Increment
 * the plague time.  Return "current" plague
 * stage.  No reports generated here anymore.
 */
int
plague_people(np, vec, cvec, etus)
	struct	natstr *np;
	register int *vec;
	register int *cvec;
	int	etus;
{
	int	stage;
	double	plg_num;
	double	plg_denom;
	double	pct_left;

	cvec[C_PTIME] -= etus;
	stage = cvec[C_PSTAGE];
	switch (stage) {
	case PLG_DYING:
		plg_num = 100.0 * etus;
		plg_denom = (np->nat_level[NAT_RLEV] + 100.0) *
			(vec[C_PTIME] + etus + 1.0);
		pct_left = 1.0 - plg_num / plg_denom;
		if (pct_left < 0.2)
			pct_left = 0.2;
		vec[I_CIVIL] = vec[I_CIVIL] * pct_left;
		vec[I_MILIT] = vec[I_MILIT] * pct_left;
		vec[I_UW] = vec[I_UW] * pct_left;
		break;
	case PLG_INFECT:
	case PLG_INCUBATE:
		break;
	case PLG_EXPOSED:
		cvec[C_PTIME] = 0;
		break;
	default:
		/* bad */
		cvec[C_PTIME] = 0;
		break;
	}
	if (cvec[C_PTIME] <= 0) {
		cvec[C_PSTAGE]--;
		cvec[C_PTIME] = 32 + (random() % 32);
	}
	return stage;
}
