#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/update/human.c,v 2.4 1995/08/16 05:51:24 empire Exp $";
#endif

/*
 * human.c
 *
 * Food related functions
 * 
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 */

#include <math.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "item.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "optlist.h"
#include "budg.h"

extern  int update_pending;

/*
 * feed the individual sector
 *
 */
int
do_feed(sp, np, vec, workp, bp, etu)
	register struct sctstr *sp;
	register struct natstr *np;
	int	*vec, *workp, *bp, etu;
{
	extern	double eatrate;
	int	people;
	int	work_avail;
	int	starved, sctwork;
	int	needed, dummy;

	/* grow people & stuff */
	sctwork = sp->sct_work;
	work_avail = total_work(sctwork, etu, vec[I_CIVIL], vec[I_MILIT],
				vec[I_UW]);

	people = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
	if (sp->sct_type != SCT_SANCT) {
		if (opt_NOFOOD == 0) {
			if (vec[I_FOOD] < 1 + etu * people * eatrate) {
				/* need to grow "emergency rations" */ 
				work_avail -= (2 * 
                                growfood(sp, vec, (int)(work_avail/2), etu));
				/* It's twice as hard to grow those than norm*/
				pt_bg_nmbr(bp, sp, I_MAX+1, work_avail);
				if (update_pending)
				  sp->sct_avail = work_avail;
			}
			if ((vec[I_FOOD] < 1 + etu * people * eatrate) &&
			    (sp->sct_own == sp->sct_oldown)){

				/* steal food from warehouses, headquarters,
				   supply ships in port, or supply units */
				int	curfood, needed;

				needed = ldround((double)(1+etu*people*eatrate),1);

				/* Now, find some food */
				vec[I_FOOD] = supply_commod(sp->sct_own,sp->sct_x,
							sp->sct_y,I_FOOD,needed);

			}
		}
		starved = feed_people(vec, etu, &needed);
		if ((starved > 0 && sp->sct_own) && (update_pending)) {
			/* don't report POGO starvation */
			wu(0, sp->sct_own, "%d starved in %s.\n", starved,
				xyas(sp->sct_x, sp->sct_y, sp->sct_own));
			if (starved > 25)
				nreport(sp->sct_own, N_DIE_FAMINE, 0, 1);
		}
		if (starved > 0) {
   		  if (update_pending)
		    starvation(sp);
		  sctwork = 0;		    
		} else {
			if (sp->sct_work < 100)
				sctwork = sp->sct_work + 8 + (random() % 15);
			if (sctwork > 100)
				sctwork = 100;
			if (update_pending)
			  sp->sct_work = sctwork;
			dummy = grow_people(sp, etu, np, &work_avail, sctwork, vec);
		}
	} else
		sctwork = sp->sct_work = 100;
	pt_bg_nmbr(bp, sp, I_CIVIL, vec[I_CIVIL]);
	pt_bg_nmbr(bp, sp, I_UW, vec[I_UW]);
	pt_bg_nmbr(bp, sp, I_MILIT, vec[I_MILIT]);
	*workp = work_avail;
	return sctwork;
}

int
growfood(sp, vec, work, etu)
	struct	sctstr *sp;
	register int *vec;
	int	work;
	int	etu;
{
	extern	double fgrate;
	extern	double fcrate;
	double	food_fertil;
	double	food_workers;
	double	food;
	int	work_used;

/* I'm being very nice and commenting out this so players
 * won't whine about starvation
	if (sp->sct_fertil == 0 || work == 0)
		return 0;
 */
	food_workers = work * fcrate;
	food_fertil = etu * sp->sct_fertil * fgrate;
	food = food_fertil;
	if (food > food_workers)
		food = food_workers;
	/*
	 * be nice; grow minimum one food unit.
	 * This makes life simpler for the player.
	 */
	vec[I_FOOD] += (int) food;
	if (vec[I_FOOD] == 0)
		vec[I_FOOD] = 1;
	if (vec[I_FOOD] > 9999)
		vec[I_FOOD] = 9999;
	work_used = (int) food / fcrate;
	return work_used;
}

/*
 * returns the number who starved, if any.
 */
int
feed_people(vec, etu, needed)
	register int *vec;
	int	etu;
	int	*needed;
{
	extern	double eatrate;
	double	food_eaten;
	double	people_left;
	int	can_eat;
	int	total_people;
	int	to_starve;
	int	starved;

	if (opt_NOFOOD)
		return 0;
	food_eaten = (etu * eatrate) *
		(vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW]);
	if (food_eaten <= 1)
		return 0;
	starved = 0;
	*needed = 0;
	if (food_eaten > vec[I_FOOD]) {
		*needed = food_eaten - vec[I_FOOD];
		if (*needed < (food_eaten - vec[I_FOOD]))
			(*needed)++;
		if (opt_NEW_STARVE) {
			can_eat = (vec[I_FOOD] / (etu * eatrate));
			total_people = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];

			/* only want to starve off at most 1/2 the populace. */
			if (can_eat < (total_people/2))
				can_eat = total_people/2;

			to_starve = total_people - can_eat;	
			while(to_starve && vec[I_UW]){
				to_starve--;
				starved++;
				vec[I_UW]--;
			}
			while(to_starve && vec[I_CIVIL]){
				to_starve--;
				starved++;
				vec[I_CIVIL]--;
			}
			while(to_starve && vec[I_MILIT]){
				to_starve--;
				starved++;
				vec[I_MILIT]--;
			}
		
			vec[I_FOOD] = 0;
		}
		else {		/* ! opt_NEW_STARVE */

			people_left = (vec[I_FOOD] + 0.01) / (food_eaten + 0.01);
			starved = vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
			/* only want to starve off at most 1/2 the populace. */
			if (people_left < 0.5)
				people_left = 0.5;
			vec[I_CIVIL] = (int) (vec[I_CIVIL] * people_left);
			vec[I_MILIT] = (int) (vec[I_MILIT] * people_left);
			vec[I_UW] = (int) (vec[I_UW] * people_left);
			starved -= vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW];
			vec[I_FOOD] = 0;
		} /* end opt_NEW_STARVE */
	} else {
		vec[I_FOOD] -= roundavg(food_eaten);
	}
	return starved;
}

/*
 * Grow babies, and add to populace.
 * XXX Might think about dropping in a birth
 * rate limitation on countries with high tech
 * production?  Maybe with just high education?
 */
int grow_people(sp, etu, np, workp, sctwork, vec)
	struct	sctstr *sp;
	register int etu;
	register struct natstr *np;
        int     *workp;
        int     sctwork;
	register int *vec;
{
	extern	double obrate;
	extern	double uwbrate;
	extern	double babyeat;
	int	newciv;
	int	newuw;
	int	new_birth;
	int	new_food;
	int	maxpop = max_pop(np->nat_level[NAT_RLEV], sp);

	newciv = 0;
	newuw = 0;
	if (vec[I_CIVIL] < maxpop) {
		new_birth = (int) roundavg(obrate * (double)(etu * vec[I_CIVIL]));
		if (opt_NOFOOD) 
			new_food = (int) (0.5 + maxpop / (2.0 * babyeat));
		else		/* we are using food */
			new_food = (int) (0.5 + vec[I_FOOD] / (2.0 * babyeat));

		newciv = new_birth;
		if (newciv > new_food)
			newciv = new_food;
		vec[I_CIVIL] += newciv;
	}
	if (vec[I_CIVIL] > maxpop)
		vec[I_CIVIL] = maxpop;
	if (vec[I_UW] < maxpop) {
		/*
		 * now grow uw's
		 */
		new_birth = (int) roundavg(uwbrate * (double)(etu * vec[I_UW]));
		if (opt_NOFOOD)
			new_food = (int) (0.5 + maxpop / (2.0 * babyeat));
		else		/* food is important */
			new_food = (int) (0.5 + vec[I_FOOD] / (2.0 * babyeat));

		newuw = new_birth;
		if (newuw > new_food)
			newuw = new_food;
		vec[I_UW] += newuw;
	}
	if (vec[I_UW] > maxpop)
		vec[I_UW] = maxpop;
	/*
	 * subtract the baby eat food (if we are using FOOD) and return
	 * # of births.
	 */
	if (opt_NOFOOD == 0 && (newciv || newuw))
		vec[I_FOOD] -= roundavg((newciv + newuw) * babyeat);
	*workp += total_work(sctwork, etu, newciv, 0, newuw);
	return newciv + newuw;
}

/*
 * percentage of people who starved
 */
int
starvation(sp)
	struct	sctstr *sp;
{
	sp->sct_work = 0;
	sp->sct_loyal += (random() % 8) + 2;
}
