#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/caploss.c,v 2.4 1995/10/22 20:49:21 empire Exp $";
#endif

/*
 * caploss.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "nat.h"
#include "var.h"
#include "sect.h"
#include "file.h"
#include "xy.h"
#include "news.h"

void
caploss(sp, coun, msg)
	struct	sctstr *sp;
	natid	coun;
	s_char	*msg;
{
	struct	natstr *natp;
	long	lose;
	long	gain;

	natp = getnatp(coun);
	if ((xrel(natp,natp->nat_xcap) != xrel(natp,sp->sct_x)) ||
	      (yrel(natp,natp->nat_ycap) != yrel(natp,sp->sct_y)))
	     return;
	pr(msg, natp->nat_cnam);
	if (coun == player->cnum) {
		player->nstat &= ~CAP;
		return;
	}
	if (sp->sct_updated == 1){
		gain = lose = natp->nat_money / 2;
		if (lose < 3000)
			lose = 3000;
		natp->nat_money -= lose;
		putnat(natp);
		if (gain >= 0)  {
			/*
		 	* since we "caused" the event to occur, that means
		 	* we might benefit as long as the cap effic is
		 	* decent.  (the cap being decent means that we
		 	* don't gain if we nuked it) 
		 	*/
			player->dolcost -= (0.2 + 0.8 * (sp->sct_effic/100.0)) * gain;
		}
		wu(0, 0, "%s just took %s's capital and gained $%d\n",
			cname(player->cnum), cname(coun),
			-(int)(player->dolcost));
		nreport(player->cnum, N_SACK_CAP, coun, 1);
		sp->sct_updated = 0;
	}
}
