#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/desi.c,v 2.4 1995/09/13 05:43:47 empire Exp $";
#endif /* not lint */

/*
 * desi.c
 *
 * redesignate sectors
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "item.h"
#include "xy.h"
#include "path.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "nat.h"
#include "optlist.h"

long do_desi();

int desi()
{
	long cash;
	long cost;
	struct	natstr *natp;

	natp = getnatp(player->cnum);
	cash = natp->nat_money;
	if (player->argp[2]) {
		cost = do_desi(natp, player->argp[1], player->argp[2], cash, 0);
		if (cost < 0)
			return (int)(-cost);
		if (chkmoney(cost, cash, player->argp[3]))
			return RET_SYN;
	}
	return (int)do_desi(natp, player->argp[1], player->argp[2], cash, 1);
}

long
do_desi(natp, sects, deschar, cash, for_real)
	struct	natstr *natp;
	s_char *sects;
	s_char *deschar;
	long    cash;
	int     for_real;
{
	register int n;
	s_char	*p;
	int	breaksanct;
	int	cap_x;
	int	cap_y;
	int     des;
	struct	nstr_sect nstr;
	struct	sctstr sect;
	struct	sctstr check;
	s_char	prompt[128];
	s_char	buf[1024];
	long    cost = 0;
	int	changed = 0;
	int	warned = 0;

	breaksanct = 0;
	if (!snxtsct(&nstr, sects))
		if (for_real)
			return (long)RET_SYN;
		else
			return (long)-RET_SYN;
	cap_x = natp->nat_xcap;
	cap_y = natp->nat_ycap;
	while (!player->aborted && nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		if (!player->god) {
			if (sect.sct_type == SCT_MOUNT ||
			    sect.sct_type == SCT_BSPAN ||
			    sect.sct_type == SCT_WASTE)
				continue;
		}
		sprintf(prompt, "%s %d%% %s  desig? ", 
			xyas(sect.sct_x, sect.sct_y, player->cnum),
			sect.sct_effic, dchr[sect.sct_type].d_name);
		if ((p = getstarg(deschar, prompt, buf)) == 0)
			continue;
		des = typematch(p, EF_SECTOR);
		if (des < 0 || (des == SCT_BSPAN && !player->god)) {
			pr("See \"info Sector-types\"\n");
			if (for_real)
				return (long)RET_FAIL;
			else
				return (long)-RET_FAIL;
		}
		if (!player->god) {
			if (des == SCT_WATER || des == SCT_MOUNT ||
			    des == SCT_SANCT) {
				pr("Only %s can make a %s!\n", cname(0),
					dchr[des].d_name);
				continue;
			}
			if (des == SCT_WASTE) {
				pr("Only a nuclear device (or %s) can make a %s!\n",
					cname(0), dchr[des].d_name);
				continue;
			}
		}
		if (sect.sct_type == des && sect.sct_newtype == des)
			continue;
		if (sect.sct_type == SCT_SANCT)
			breaksanct++;
		if (sect.sct_x == cap_x && sect.sct_y == cap_y &&
				des != SCT_CAPIT && des != SCT_SANCT &&
				des != SCT_MOUNT && for_real)
			pr("You have redesignated your capital!\n");
		if (des == SCT_HARBR) {
			for (n = 1; n <= 6; n++) {
				getsect(nstr.x + diroff[n][0],
					nstr.y + diroff[n][1], &check);
				if (check.sct_type == SCT_WATER)
					break;
				if (check.sct_type == SCT_BSPAN)
					break;
			}
			if (n > 6) {
				if (for_real)
					pr("%s does not border on water.\n",
					   xyas(nstr.x, nstr.y, player->cnum));
				if (player->god) {
					if (for_real)
						pr("But if it's what you want ...\n");
				} else
					continue;
			}
		}
		if (sect.sct_type == SCT_SANCT && !player->god)
			continue;
		n = sect.sct_type;
		if ((sect.sct_newtype != des) && (sect.sct_type != des) && dchr[des].d_cost) {
			if (for_real) {
				if (check_cost(!deschar, dchr[des].d_cost, cash, &warned, player->argp[3]))
					break;
			} else {
				cost += dchr[des].d_cost;
				continue;
			}
		}
		if (sect.sct_effic < 5 || player->god) {
			sect.sct_type = des;
			sect.sct_effic = 0;
			changed += setmap(player->map, sect.sct_x, sect.sct_y,
				dchr[des].d_mnem, 0);
		}
		sect.sct_newtype = des;
		putsect(&sect);
		if (opt_EASY_BRIDGES == 0) { /* may cause a bridge fall */
			if (n != SCT_BHEAD)
				continue;
			bridgefall(&sect);
		}
	}
	if (for_real) {
		if (changed)
			ef_write(EF_MAP, player->cnum, player->map);
		if (breaksanct)
			bsanct();
		return (long)RET_OK;
	} else {
		return cost;
	}
}
