#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/capi.c,v 2.0 1995/01/25 19:23:25 empire Exp $";
#endif /* not lint */

/*
 * capi.c
 *
 * move your capital
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "xy.h"
#include "nsc.h"
#include "item.h"
#include "file.h"

capi()
{
	struct	sctstr sect;
	struct	natstr *np;
	struct	nstr_sect nstr;
	int	found;

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	np = getnatp(player->cnum);
	found = 0;
	while (!found && nxtsct(&nstr, &sect)) {
		if (player->owner && (sect.sct_type == SCT_CAPIT ||
			sect.sct_type == SCT_MOUNT))
			found++;
	}
	if (!found)
		return RET_FAIL;
	if (sect.sct_x == np->nat_xcap && sect.sct_y == np->nat_ycap) {
		pr("%s is already your capital.\n",
			xyas(sect.sct_x, sect.sct_y, player->cnum));
		return RET_FAIL;
	}
	player->nstat |= CAP;
	np->nat_xcap = sect.sct_x;
	np->nat_ycap = sect.sct_y;
	putnat(np);
	pr("Capital now at %s.\n", xyas(sect.sct_x, sect.sct_y, player->cnum));
	return 0;
}
