#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/scut.c,v 2.5 1995/10/01 22:06:29 empire Exp $";
#endif /* not lint */

/*
 * scut.c
 *
 * Scuttle ships or planes
 * Taken from scra.c
 */

#include "misc.h"
#include "player.h"
#include "sect.h"
#include "news.h"
#include "var.h"
#include "xy.h"
#include "ship.h"
#include "land.h"
#include "plane.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"


union item_u {
	struct shpstr ship;
	struct plnstr plane;
	struct lndstr land;
};

scut()
{
	struct	nstr_item ni;
	union	item_u item;
	int	type;
	struct	mchrstr *mp;
	struct	plchrstr *pp;
	struct	lchrstr *lp;
	s_char	*p;
#ifdef TRADESHIPS
	float	cash;
	int	dist;
	struct	sctstr sect;
	s_char	m1[80],m2[80];
	int	scuttled;
	extern	int   trade_1_dist;	/* less than this gets no money */
	extern	int   trade_2_dist;	/* less than this gets trade_1 money */
	extern	int   trade_3_dist;	/* less than this gets trade_2 money */
	extern	float trade_1;		/* return on trade_1 distance */
	extern	float trade_2;		/* return on trade_2 distance */
	extern	float trade_3;		/* return on trade_3 distance */
	extern	float trade_ally_bonus;	/* 20% bonus for trading with allies */
	extern	float trade_ally_cut;	/* 10% bonus for ally you trade with */
	float	ally_cash;
#endif /* TRADESHIPS */
	struct  nstr_item ni2;
	struct  plnstr plane;
	struct	sctstr sect2;
	s_char	prompt[128];
	s_char	buf[1024];
	struct	natstr *np;

#ifdef TRADESHIPS
	bzero(m1,80);
	bzero(m2,80);
#endif /* TRADESHIPS */
	if (!(p = getstarg(player->argp[1], "Ship, land, or plane? ", buf)))
		return RET_SYN;
	switch (*p) {
	case 's':
		type = EF_SHIP; break;
	case 'p':
		type = EF_PLANE; break;
	case 'l':
		type = EF_LAND; break;
	default:
		pr("Ships, land units, or planes only! (s, l, p)\n");
		return RET_SYN;
	}
	sprintf(prompt, "%s(s)? ", ef_nameof(type));
	if ((p = getstarg(player->argp[2], prompt, buf)) == 0)
		return RET_SYN;
	if (!snxtitem(&ni, type, p))
		return RET_SYN;
	if (p && (isalpha(*p) || (*p == '*') || (*p == '~') || issector(p)
		|| islist(p))){
		s_char y_or_n[80], bbuf[80];

		if (type == EF_SHIP) {
			if (*p == '*')
				sprintf(bbuf,"all ships");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned ships");
			else if (issector(p))
				sprintf(bbuf,"all ships in %s",p);
			else if (isalpha(*p))
				sprintf(bbuf,"fleet %c",*p);
			else
				sprintf(bbuf,"ships %s",p);
		} else if (type == EF_LAND) {
			if (*p == '*')
				sprintf(bbuf,"all land units");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned land units");
			else if (issector(p))
				sprintf(bbuf,"all units in %s",p);
			else if (isalpha(*p))
				sprintf(bbuf,"army %c",*p);
			else
				sprintf(bbuf,"units %s",p);
		} else {
			if (*p == '*')
				sprintf(bbuf,"all planes");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned planes");
			else if (issector(p))
				sprintf(bbuf,"all planes in %s",p);
			else if (isalpha(*p))
				sprintf(bbuf,"wing %c",*p);
			else
				sprintf(bbuf,"planes %s",p);
		}
		sprintf(y_or_n,"Really scuttle %s? ", bbuf);
		if (!confirm(y_or_n))
			return RET_FAIL;
	}
	while (nxtitem(&ni, (s_char *)&item)) {
#ifdef TRADESHIPS
		pr(m1);
		pr(m2);
		bzero(m1,80);
		bzero(m2,80);
		scuttled = 0;
#endif /* TRADESHIPS */
		if (!player->owner)
			continue;
		if (type == EF_SHIP) {			
			mp = &mchr[item.ship.shp_type];
			pr("%s", prship(&item.ship));
#ifdef TRADESHIPS
			getsect(item.ship.shp_x,item.ship.shp_y,&sect);
			if ((mp->m_flags & M_TRADE) &&
				(sect.sct_type == SCT_HARBR)){

				if (!sect.sct_own){
					scuttled=1;
					item.ship.shp_own = 0;
					putship(item.ship.shp_uid,
						(s_char *)&item.ship);
					continue;
				}
				dist = mapdist(item.ship.shp_x, item.ship.shp_y,
					item.ship.shp_orig_x,
					item.ship.shp_orig_y);
				if (dist < trade_1_dist){
					sprintf(m2,"This port is too close to ship's home port to make a profit, sorry.\n");
					cash = 0;
				}
				else if (dist < trade_2_dist)
					cash = (1.0 + trade_1*((float)dist));
				else if (dist < trade_3_dist)
					cash = (1.0 + trade_2*((float)dist));
				else
					cash = (1.0 + trade_3*((float)dist));
				cash *= mp->m_cost;
				cash *= (((float)item.ship.shp_effic) / 100.0);
				sprintf(m1,"Ship has gone %d sects\n",dist);

				if (sect.sct_own != item.ship.shp_own){
					cash *= (1.0 + trade_ally_bonus);
					ally_cash = cash * trade_ally_cut;
					np = getnatp(sect.sct_own);
					np->nat_money += ally_cash;
					putnat(np);
					wu(0,sect.sct_own,
					  "Trade with %s nets you $%d at %s\n",
					    cname(item.ship.shp_own),
					    (int)ally_cash, xyas(sect.sct_x,
					    sect.sct_y, sect.sct_own));
					if (item.ship.shp_own != item.ship.shp_orig_own){
						nreport(item.ship.shp_own,
						N_PIRATE_TRADE,
						item.ship.shp_orig_own, 1);
					} else {
						nreport(item.ship.shp_own,
						N_TRADE, sect.sct_own, 1);
					}
				} else {
					if (item.ship.shp_own != item.ship.shp_orig_own)
						nreport(item.ship.shp_own,
						N_PIRATE_KEEP,
						item.ship.shp_orig_own, 1);
				}
				player->dolcost -= cash;
			}
			scuttled=1;
#endif /* TRADESHIPS */
			getsect(item.ship.shp_x,item.ship.shp_y,&sect2);
			snxtitem_all(&ni2, EF_PLANE);
			while (nxtitem(&ni2, (s_char *)&plane)) {
				if (plane.pln_own == 0)
					continue;
				if (plane.pln_ship == item.ship.shp_uid){
					if (sect2.sct_own != player->cnum){
						wu(0,player->cnum,"Plane %d scuttled in %s\n",ni2.cur,xyas(plane.pln_x, plane.pln_y,player->cnum));
						plane.pln_own = 0;
					}
					else{
						wu(0,player->cnum,"Plane %d transferred off ship %d to %s\n",ni2.cur,item.ship.shp_uid,xyas(plane.pln_x, plane.pln_y,player->cnum));
						plane.pln_ship = -1;
					}
					putplane(plane.pln_uid, (s_char *)&plane);
				}
			}
			item.ship.shp_own = 0;
			putship(item.ship.shp_uid, (s_char *)&item.ship);
		}else
		if (type == EF_LAND) {
			if (item.land.lnd_ship >= 0){
				pr("%s is on a ship, and cannot be scuttled!\n", prland(&item.land));
				continue;
			}
			lp = &lchr[item.land.lnd_type];
			pr("%s", prland(&item.land));
			getsect(item.land.lnd_x,item.land.lnd_y,&sect2);
			snxtitem_all(&ni2, EF_PLANE);
			while (nxtitem(&ni2, (s_char *)&plane))
				if (plane.pln_land == item.land.lnd_uid){
					if (sect2.sct_own != player->cnum){
						wu(0,player->cnum,"Plane %d scuttled in %s\n",ni2.cur,xyas(plane.pln_x, plane.pln_y,player->cnum));
						plane.pln_own = 0;
					}
					else{
						wu(0,player->cnum,"Plane %d transferred off land unit %d to %s\n",ni2.cur,item.land.lnd_uid,xyas(plane.pln_x, plane.pln_y,player->cnum));
						plane.pln_land = -1;
					}
					putplane(plane.pln_uid, (s_char *)&plane);
				}
			item.land.lnd_own = 0;
			putland(item.land.lnd_uid, (s_char *)&item.land);
#ifdef TRADESHIPS
			scuttled=1;
#endif /* TRADESHIPS */
		} else {
			pp = &plchr[item.plane.pln_type];
			pr("%s", prplane(&item.plane));
#ifdef TRADESHIPS
			scuttled=1;
#endif /* TRADESHIPS */
			if (item.plane.pln_ship >= 0){
				struct shpstr ship;
				getship(item.plane.pln_ship,&ship);
				take_plane_off_ship(&item.plane,&ship);
			}
			item.plane.pln_own = 0;
			putplane(item.plane.pln_uid, (s_char *)&item.plane);
		}
#ifdef TRADESHIPS
		if (scuttled){
#endif /* TRADESHIPS */
			pr(" scuttled in %s\n", 
			   xyas(item.ship.shp_x, item.ship.shp_y , player->cnum));
#ifdef TRADESHIPS
		}
#endif /* TRADESHIPS */
	}
#ifdef TRADESHIPS
	pr(m1);
	pr(m2);
	bzero(m1,80);
	bzero(m2,80);
#endif /* TRADESHIPS */
	return RET_OK;
}

