#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/budg.c,v 2.14 1995/10/24 04:39:16 empire Exp $";
#endif

/*
 * budg.c
 *
 * calculate production levels, prioritize
 *
 * Thomas Ruschak, 1992
 *
 * modified by
 * Ville Virrankoski, 1995
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "nsc.h"
#include "sect.h"
#include "product.h"
#include "nat.h"
#include "item.h"
#include "file.h"
#include "deity.h"
#include "ship.h"
#include "land.h"
#include "plane.h"
#include "optlist.h"

#include "budg.h"
#ifndef MIN
#define MIN(x,y)	((x) > (y) ? (y) : (x))
#endif

int	UPDATED[WORLD_X][WORLD_Y];

extern	int etu_per_update;
extern	double bankint;
extern	double money_civ;
extern	double money_uw;
extern	double money_mil;
extern	double obrate, uwbrate; 
extern	int etu_per_update;
extern	double money_res;

s_char *dotsprintf();

int
budg()
{
	register int a, b;
	s_char	stype=0, *pq;
	int	priority, x;
	int	costs[SCT_MAXDEF+1], taxes=0, bars=0, mil=0, cap=0;
	int	Ncivs=0, Nuws=0, Nbars=0;
	int	n;
	int	amounts[SCT_MAXDEF+1];
	int	income = 0, expenses = 0;
	int	dbuild = 0;
	int	sbuild=0,smaint=0,pbuild=0,pmaint=0, ships=0,planes=0;
	int	nsbuild=0,npbuild=0, which=0;
	int	lbuild=0,lmaint=0,units=0,nlbuild=0;
	struct	natstr *np;
	s_char	buf[1024];
	s_char	in[80];

	bzero(costs,sizeof(costs));
	bzero(amounts,sizeof(amounts));
	bzero(UPDATED,sizeof(UPDATED));

	np=getnatp(player->cnum);
	if (player->argp[1] != (s_char *)0){
		if (goodsect(player->argp[1][0]))
			stype=player->argp[1][0];
		else switch(player->argp[1][0]){
			case 'P': 
			case 'S': 
			case 'L': 
			case 'A': 
			case 'M': 
			case 'N': 
			case 'C': stype = player->argp[1][0]; break;
			default: return RET_SYN;
		}
	}
	if ((stype != 0) && (stype != 'C'))
		pq = getstarg(player->argp[2], "Priority? ", buf);
	else
		pq = (s_char *)0;
	if (pq != (s_char *)0)
		if (isdigit(*pq)){
			priority=(atoi(pq) < 0 ? -1*atoi(pq) : atoi(pq));
			if (priority >= SCT_MAXDEF+8){
				pr("Priorities must be less than %d!\n",
					SCT_MAXDEF+8);
				return RET_FAIL;
			}
			for(x=0;x<SCT_MAXDEF+8;x++)
				if (priority &&
					(np->nat_priorities[x] == priority)){
					pr("Priorities must be unique!\n");
					return RET_FAIL;
				}
		}
		else if (*pq == '~')
			priority = -1;
		else
			return RET_SYN;

	if ((stype) && !player->god){
		if (!isupper(stype)){
			which=0;
			while ((which<SCT_MAXDEF+2) &&
				(stype != dchr[which].d_mnem))
				which++;
			if (which == SCT_MAXDEF+2)
				return RET_SYN;
		}else{
			switch(stype){
				case 'P': which=PRI_PBUILD;break;
				case 'S': which=PRI_SBUILD;break;
				case 'L': which=PRI_LBUILD;break;
				case 'A': which=PRI_LMAINT;break;
				case 'M': which=PRI_SMAINT;break;
				case 'N': which=PRI_PMAINT;break;
				case 'C': which=(-1);break;
				default:  return RET_SYN;
			}
		}
		if (which == -1){
			for(x=0;x<SCT_MAXDEF+8;x++){
				np->nat_priorities[x] = -1;
			}
		} else {
			np->nat_priorities[which] = priority;
		}
		
	}
	putnat(np);

	calc_all(costs,amounts,&taxes,&Ncivs,&Nuws,&bars,&Nbars,&mil,&cap,&ships,&sbuild,&nsbuild,
		&smaint,&units,&lbuild,&nlbuild,&lmaint,&planes,&pbuild,
		&npbuild,&pmaint);

	income = taxes + bars;
	pr("Sector Type\t\tAbbr\tProduction\tPriority\t    Cost\n");
	for(x=0;x<SCT_MAXDEF+1;x++){
		if (!costs[x] && np->nat_priorities[x] == -1)
			continue;
		if (!pchr[dchr[x].d_prd].p_cost &&
		    np->nat_priorities[x] == -1 &&
		    x != SCT_ENLIST) {
			dbuild += costs[x];
			continue;
		}
		
		pr("%-17s\t%c\t",dchr[x].d_name,dchr[x].d_mnem);
		if (x == SCT_ENLIST)
			pr("%d mil    \t",amounts[x]);
		else if (pchr[dchr[x].d_prd].p_cost != 0)
			pr("%d %-7s\t",amounts[x],
			   pchr[dchr[x].d_prd].p_sname);
		else pr("\t\t");
		
		if (np->nat_priorities[x] != -1){
			pr("%d",np->nat_priorities[x]);
		}
		pr("\t");
		pr("\t");
		if (np->nat_priorities[x] != 0){
			if ((np->nat_money+income-expenses) > 0){
				pr("%8d",costs[x]);
				expenses += costs[x];
			}
			else
				pr("[%7d]",costs[x]);
		}else{
			if ((np->nat_money+income-expenses) > 0)
				pr("(%7d)",costs[x]);
			else
				pr("[(%7d)]",costs[x]);
		}

		pr("\n");
	}

	if (lbuild) {
		sprintf(buf,"%d unit%s",nlbuild,splur(nlbuild));
		pr("Unit building\t\tL\t%-16s", buf);
		if (np->nat_priorities[PRI_LBUILD] != -1)
			pr("%d",np->nat_priorities[PRI_LBUILD]);
		prexpense(np->nat_money+income, &expenses, np->nat_priorities[PRI_LBUILD], -1*lbuild);
	}

	if (lmaint) {
		sprintf(buf,"%d unit%s",units,splur(units));
		pr("Unit maintenance\tA\t%-16s",buf);
		if (np->nat_priorities[PRI_LMAINT] != -1)
			pr("%d",np->nat_priorities[PRI_LMAINT]);
		prexpense(np->nat_money+income, &expenses, np->nat_priorities[PRI_LMAINT], -1*lmaint);
	}

	if (sbuild) {
		sprintf(buf,"%d ship%s",nsbuild,splur(nsbuild));
		pr("Ship building\t\tS\t%-16s", buf);
		if (np->nat_priorities[PRI_SBUILD] != -1)
			pr("%d",np->nat_priorities[PRI_SBUILD]);
		prexpense(np->nat_money+income, &expenses, np->nat_priorities[PRI_SBUILD], -1*sbuild);
	}

	if (smaint) {
		sprintf(buf,"%d ship%s",ships,splur(ships));
		pr("Ship maintenance\tM\t%-16s",buf);
		if (np->nat_priorities[PRI_SMAINT] != -1)
			pr("%d",np->nat_priorities[PRI_SMAINT]);
		prexpense(np->nat_money+income, &expenses, np->nat_priorities[PRI_SMAINT], -1*smaint);
	}

	if (pbuild) {
		sprintf(buf,"%d plane%s",npbuild,splur(npbuild));
		pr("Plane building\t\tP\t%-16s",buf);
		if (np->nat_priorities[PRI_PBUILD] != -1)
			pr("%d",np->nat_priorities[PRI_PBUILD]);
		prexpense(np->nat_money+income, &expenses, np->nat_priorities[PRI_PBUILD], -1*pbuild);
	}

	if (pmaint) {
		sprintf(buf,"%d plane%s",planes,splur(planes));
		pr("Plane maintenance\tN\t%-16s",buf);
		if (np->nat_priorities[PRI_PMAINT] != -1)
			pr("%d",np->nat_priorities[PRI_PMAINT]);
		prexpense(np->nat_money+income, &expenses, np->nat_priorities[PRI_PMAINT], -1*pmaint);
	}
	if (dbuild) {
		pr("Sector building\t\t\t\t\t\t\t%8d\n",dbuild);
		expenses += dbuild;
	}
	if (mil) {
		
		n = (mil - np->nat_reserve * money_res * etu_per_update)/(etu_per_update*money_mil);
		sprintf(in, "%d mil, %d res", n, np->nat_reserve);
		pr("Military payroll\t\t%-32s%8d\n",
		   in, -mil);
		expenses -= mil;
	}
	if (cap) {
		n = cap/etu_per_update;
		sprintf(in, "%d %s",
			n,
			n==1?opt_BIG_CITY?"city":"capital":opt_BIG_CITY?"cities":"capitals");
		pr("%s maintenance\t\t%-32s%8d\n",
		   opt_BIG_CITY?"City":"Capital",
		   in,
		   cap);
		expenses += cap;
	}
	pr("Total expenses%s\n", dotsprintf(buf,"%58d", expenses));
	if (taxes) {
		sprintf(in, "%d civ%s, %d uw%s",
			Ncivs,splur(Ncivs),
			Nuws,splur(Nuws));
		pr("Income from taxes\t\t%-32s%+8d\n",
		   in,
		   taxes);
	}
	if (bars) {
		sprintf(in, "%d bar%s",	Nbars, splur(Nbars));
		pr("Income from bars\t\t%-32s%+8d\n",
		   in,
		   bars);
	}
	pr("Total income%s\n", dotsprintf(buf,"%+60d", income));
	pr("Balance forward\t\t\t\t\t\t      %10d\n", np->nat_money);
	pr("Estimated delta\t\t\t\t\t\t      %+10d\n",income-expenses);
	pr("Estimated new treasury%s\n",dotsprintf(buf,"%50d",np->nat_money+income-expenses));
	if (((np->nat_money+income-expenses) < 0) && !player->god){
		pr("After processsing sectors, you will be broke!\n");
		pr("Sectors will not produce, distribute, or deliver!\n\n");
	}

	return RET_OK;
}

int
calc_all(costs,amounts,taxes,Ncivs,Nuws,bars,Nbars,mil,cap,ships,sbuild,nsbuild,smaint,
	units,lbuild,nlbuild,lmaint,planes,pbuild,npbuild,pmaint)
	int	costs[SCT_MAXDEF+1];
	int	amounts[SCT_MAXDEF+1];
	int	*taxes,*Ncivs,*Nuws,*bars,*Nbars,*mil,*cap;
	int	*ships,*sbuild,*nsbuild,*smaint;
	int	*units,*lbuild,*nlbuild,*lmaint;
	int	*planes,*pbuild,*npbuild,*pmaint;
{
	register int y,z;
	struct	natstr *natp;
	int	sm=0,sb=0,pm=0,pb=0,lm=0,lb=0;
	int     *bp;
	int     n;
	struct sctstr *sp;
	int     etus=etu_per_update;
	int     newcivs, maxcivs;
	extern long sea_money[MAXNOC];
	extern long lnd_money[MAXNOC];
	extern long air_money[MAXNOC];
	extern int mil_dbl_pay;

	lnd_money[player->cnum] = sea_money[player->cnum] = 0;
	air_money[player->cnum] = 0;
	mil_dbl_pay = 0;
	natp = getnatp(player->cnum);
	bp = (int *)calloc(WORLD_X * WORLD_Y * 8, sizeof(int));
	for (n=0;sp = getsectid(n) ;n++){
    	  fill_update_array(bp, sp);
	  newcivs = gt_bg_nmbr(bp, sp, I_CIVIL);
	  newcivs += (int)roundavg(obrate * (double) (etus * newcivs));
	  maxcivs = max_pop(natp->nat_level[NAT_RLEV], sp);
	  newcivs = min(maxcivs, newcivs);
	  pt_bg_nmbr(bp, sp, I_CIVIL, newcivs);
	}
    
	*mil += (int) (natp->nat_reserve * money_res * etu_per_update);

	for(y=1;y<SCT_MAXDEF+8;y++){
		for(z=0;z<SCT_MAXDEF+8;z++)
			if (natp->nat_priorities[z] == y)
				switch(z){
					case PRI_SMAINT:
						*ships=prod_ship(etus,
							player->cnum,bp,0);
						*smaint=sea_money[player->cnum]- *sbuild;
						sm=1;
						break;
					case PRI_SBUILD:
						*nsbuild=prod_ship(etus,
							player->cnum,bp,1);
						*sbuild=sea_money[player->cnum]- *smaint;
						sb=1;
						break;
					case PRI_LMAINT:
						*units=prod_land(etus,
							player->cnum,bp,0);
						*lmaint=lnd_money[player->cnum]- *lbuild - money_mil * etus * mil_dbl_pay;
						sb=1;
						break;
					case PRI_LBUILD:
						*nlbuild=prod_land(etus,
							player->cnum,bp,1);
						*lbuild=lnd_money[player->cnum]- *lmaint;
						lb=1;
						break;
					case PRI_PMAINT:
						*planes=prod_plane(etus,
							player->cnum,bp,0);
						*pmaint=air_money[player->cnum]- *pbuild;
						pm=1;
						break;
					case PRI_PBUILD:
						*npbuild=prod_plane(etus,
							player->cnum,bp,1);
						*pbuild=air_money[player->cnum]- *pmaint;
						pb=1;
						break;
					default:
						calc_prod(costs,amounts,taxes,
							  Ncivs,Nuws,
							  bars,Nbars,
							  mil,
							  cap,z);
						break;
				}
	}
	/* 0 is maintain, 1 is build */
	if (!sm) {
		*ships=prod_ship(etus,player->cnum,bp,0);
		*smaint=sea_money[player->cnum]- *sbuild;
	}
	if (!sb) {
		*nsbuild=prod_ship(etus,player->cnum,bp,1);
		*sbuild=sea_money[player->cnum]- *smaint;
	}
	if (!lm) {
		*units=prod_land(etus,player->cnum,bp,0);
	        *lmaint=lnd_money[player->cnum]- *lbuild;
	}
	if (!lb) {
		*nlbuild=prod_land(etus,player->cnum,bp,1);
		*lbuild=lnd_money[player->cnum]- *lmaint;
	}
	if (!pm) {
		*planes=prod_plane(etus,player->cnum,bp,0);
		*pmaint=air_money[player->cnum]- *pbuild;
	}
	if (!pb) {
		*npbuild=prod_plane(etus,player->cnum,bp,1);
		*pbuild=air_money[player->cnum]- *pmaint;
	}

	/* produce all sects that haven't produced yet */
	calc_prod(costs,amounts,taxes,Ncivs,Nuws,bars,Nbars,mil,cap,bp,-1);
	lnd_money[player->cnum] = sea_money[player->cnum] = 0;
	air_money[player->cnum] = 0;
	free(bp);
}

int
calc_prod(costs,amounts,taxes,Ncivs,Nuws,bars,Nbars,mil,cap,bp,sector_type)
	int	costs[SCT_MAXDEF+1];
	int	amounts[SCT_MAXDEF+1];
	int	*taxes,*Ncivs,*Nuws,*bars,*Nbars,*mil,*cap,*bp,sector_type;
{
	struct	sctstr sect;
	struct	natstr *natp;
	struct	nstr_sect nstr;
	struct	pchrstr *pp;
	double  effic;
	double  prodeff;
	double  real;		    /* floating pt version of act */
	double  work;
	int     act;		    /* actual production */
	int     cost;
	int     max;		    /* production w/infinate materials */
	double  maxtake;
	int     take;
	int     there;
	int     totcomp;	    /* sum of component amounts */
	int     used;		    /* production w/infinite workforce */
	int     wforce;
	u_short	*amount;	    /* amount for component pointer */
	u_char	*comp;		    /* component pointer */
	u_char	*endcomp;
	u_char  vtype;
	s_char	*resource;
	int     items[I_MAX+1];
	int	bwork;
	int	twork;
	int	type;
	int     etu=etu_per_update;
	int	eff,civs,uws;
	float	t=0.0;
	int	lcms, hcms;
	int	maxpop;
#ifdef BIG_CITY
	u_char	otype;
#endif

	natp = getnatp(player->cnum);

	snxtsct_all(&nstr);
	while (nxtsct(&nstr, &sect)) {
		if ((sect.sct_own != player->cnum) && !player->god)
			continue;
		if ((sect.sct_type != sector_type) && (sector_type != (-1)))
			continue;

		if (UPDATED[sect.sct_x][sect.sct_y])
			continue;

		UPDATED[sect.sct_x][sect.sct_y] = 1;

                getvec(VT_ITEM, items, (s_char *)&sect, EF_SECTOR);

		t = 0.0;

		t += civ_taxes(items[I_CIVIL], sect.sct_effic);

		t += uw_taxes(items[I_UW], sect.sct_effic);

		*Ncivs += items[I_CIVIL];
		*Nuws += items[I_UW];

		*taxes += (int) t;

		*mil += (items[I_MILIT] * etu_per_update * money_mil);

		civs = min(9999, (int) ((obrate * (double) etu_per_update + 1.0)
		       * (double) items[I_CIVIL]));
		uws = min(9999, (int) ((uwbrate * (double) etu_per_update + 1.0)
		       * (double) items[I_UW]));

		natp = getnatp(sect.sct_own);
		maxpop = max_pop((float)natp->nat_level[NAT_RLEV], &sect);
		civs = gt_bg_nmbr(bp, &sect, I_CIVIL);
		uws = min(uws, maxpop);
		pt_bg_nmbr(bp, &sect, I_UW, uws);
		/* This isn't quite right, since research might rise/fall */
		/* during the update, but it's the best we can really do  */
		wforce = (int)
			((civs * sect.sct_work) / 100.0
			+ uws + items[I_MILIT] * 2 / 5.0);

		if ((sect.sct_type == SCT_CAPIT) && (sect.sct_effic > 60))
			*cap += etu_per_update;

		if (sect.sct_type == SCT_BANK) {
			*Nbars += items[I_BAR];
			*bars += items[I_BAR] * etu_per_update * bankint
				* sect.sct_effic / 100;
		}

		if (sect.sct_off)
			continue;
		work = roundavg((etu_per_update * wforce) / 100.0);
		bwork = (int)(work/2);

		type = sect.sct_type;
		eff = sect.sct_effic;
		if(sect.sct_newtype != type) {
			twork = (eff+3)/4;
			if(twork > bwork) {
				twork = bwork;
			}
			bwork -= twork;
			eff -= twork*4;
			costs[sect.sct_type] += twork;
#ifdef BIG_CITY
			otype = type;
#endif /* BIG_CITY */
			if(eff <= 0) {
				type = sect.sct_newtype;
				eff = 0;
			}
#ifdef BIG_CITY
			if (!eff && dchr[otype].d_pkg == UPKG &&
			    dchr[type].d_pkg != UPKG) {
				civs = min(civs, max_pop(natp->nat_level[NAT_RLEV], 0));
				uws = min(uws, max_pop(natp->nat_level[NAT_RLEV], 0));
				wforce = (int)
					((civs * sect.sct_work) / 100.0
					 + uws + items[I_MILIT] * 2 / 5.0);

				work = etu_per_update * wforce / 100.0;
				bwork = min((int)(work/2), bwork);
			}
#endif /* BIG_CITY */

			twork = 100 - eff;
			if(twork > bwork) {
				twork = bwork;
			}

                        if (dchr[type].d_lcms>0){
                                lcms = gt_bg_nmbr(bp, &sect, I_LCM);
                                lcms /= dchr[type].d_lcms;
                                if (twork > lcms)
                                        twork = lcms;
			}
			if (dchr[type].d_hcms>0){
                                hcms = gt_bg_nmbr(bp, &sect, I_HCM);
                                hcms /= dchr[type].d_hcms;
                                if (twork > hcms)
                                        twork = hcms;
                        }

			costs[type] += twork*dchr[type].d_build;
			bwork -= twork;
			eff += twork;
		}
		else if(eff < 100) {
			twork = 100 - eff;
			if(twork > bwork) {
				twork = bwork;
			}
                        if (dchr[type].d_lcms>0){
                                lcms = gt_bg_nmbr(bp, &sect, I_LCM);
                                lcms /= dchr[type].d_lcms;
                                if (twork > lcms)
                                        twork = lcms;
			}
			if (dchr[type].d_hcms>0){
                                hcms = gt_bg_nmbr(bp, &sect, I_HCM);
                                hcms /= dchr[type].d_hcms;
                                if (twork > hcms)
                                        twork = hcms;
                        }

			costs[type] += twork*dchr[type].d_build;

			bwork -= twork;
			eff += twork;
		}
		work = work/2 + bwork;

		if(eff < 60 || (type != SCT_ENLIST && eff < 61))
			continue;

		effic = eff/100.0;
		if (effic > 1.0)
			effic = 1.0;

		pt_bg_nmbr(bp, &sect, I_MAX+1, work);
		if (dchr[type].d_prd == 0 && type != SCT_ENLIST)
			continue;

		totcomp = 0;
		pp = &pchr[dchr[type].d_prd];
		vtype = pp->p_type;
		/*
		 * sect effic  (inc improvements)
		 */
		if (type == SCT_ENLIST)
			goto is_enlist;
		if (pp->p_nrndx != 0) {
			totcomp++;
			resource = ((s_char *) &sect) + pp->p_nrndx;
			effic = (*resource * effic) / 100.0;
			if (pp->p_nrdep > 0) {
				maxtake = (*resource * 100.0) / pp->p_nrdep;
				if (effic > maxtake)
					effic = maxtake;
			}
		}
		/*
		 * production effic.
		 */
		if (pp->p_nlndx >= 0) {
			prodeff = natp->nat_level[pp->p_nlndx] - pp->p_nlmin;
			if (prodeff < 0.0) {
				prodeff = 0.0;
			}
			prodeff = prodeff / (prodeff + pp->p_nllag);
		} else {
			prodeff = 1.0;
		}
		used = 999;
		comp = pp->p_vtype;
		endcomp = pp->p_vtype + pp->p_nv;
		amount = pp->p_vamt;
		while (comp < endcomp) {
			used = min(used,
			    (int)(getvar((int)*comp, (s_char *)&sect, EF_SECTOR) /
			    	*amount));
			totcomp += *amount;
			++comp;
			++amount;
		}
		if (totcomp == 0)
			continue;
		/*
		 * is production limited by resources or
		 * workforce?
		 */
		max = (int) (work * effic / (double) totcomp) + 0.5;
		act = min(used, max);
		/*
		 * some things are easier to make..  food,
		 * pet, etc.
		 */
		act = (int) (pp->p_effic * 0.01 * act) + 0.5;

		real = act * prodeff;

		if (vtype != 0) {
			if (real < 0.0)
				real = 0.0;
			if ((there = getvar(
				(int)vtype, (s_char *)&sect, EF_SECTOR)) >= 9999) {
				/*
				 * production backlog
				 */
				there = 9999;
			}
			act = min(act, 9999 - there);
		}

		if (prodeff != 0)
			take = real / prodeff;
		else
			take = 0.0;

		if (take > 999.0)
			take = 999.0;
		cost = take * pp->p_cost;
		take = take / ((double) pp->p_effic * 0.01);
is_enlist:
		if (type != SCT_ENLIST) {
			work -= (totcomp * (int)(real+0.5));
			pt_bg_nmbr(bp, &sect,I_MAX+1, work);
			amounts[type] += (real+0.5);
			costs[type] += cost;
		} else {
			int	maxmil;
			int	enlisted;

			enlisted = 0;
			maxmil = (civs / 2) - items[I_MILIT];
			if (maxmil > 0) {
				enlisted = (etu_per_update * (10 + items[I_MILIT]) * 0.05);
				if (enlisted > maxmil)
					enlisted = maxmil;
			}
			if (enlisted < 0)
				enlisted = 0;

			if (sect.sct_oldown != sect.sct_own)
				enlisted = 0;

			amounts[type] += enlisted;
			costs[type] += enlisted*3;
			items[I_MILIT] += enlisted;
			continue;
		}

	}

}

goodsect(c)
char	c;
{
	register int x;

	for(x=4;x<SCT_MAXDEF+2;x++)
		if (dchr[x].d_mnem == c)
			return 1;

	return 0;
}

s_char *
dotsprintf(buf, format, data)
	s_char	*format;
	int	data;
	s_char	*buf;
{
	sprintf(buf, format, data);
	return (s_char *)memset(buf, '.', strspn(buf, " "));
}

prexpense(cash, expensesp, priority, amount)
	long	cash;
	int	*expensesp;
	s_char	priority;
	int	amount;
{
	if (cash > *expensesp) {
		if (priority) {
			pr("\t\t%8d\n",amount);
			*expensesp += amount;
		} else
			pr("\t\t(%7d)\n",amount);
	} else {
		if (priority) {
			pr("\t\t[%7d]\n", amount);
			*expensesp += amount;
		} else
			pr("\t\t[(%6d)]\n", amount);
	}
}

