#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/rela.c,v 2.0 1995/01/25 19:23:25 empire Exp $";
#endif /* not lint */

/*
 * rela.c
 *
 * hacked from nati.c
 *
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "nat.h"
#include "sect.h"
#include "file.h"
#include "xy.h"

/*
 * report relations with other countries.
 * Optional argument reports relations from the
 * viewpoint of another country
 */
int
rela()
{
	struct	natstr *natp;
	struct	natstr *np;
	natid	cn;
	natid	as;
	int	n;

	if (player->argp[1] == 0)
		as = player->cnum;
	else {
		if ((n = natarg(player->argp[1], "Which country? ")) <= 0) {
			pr("Bad country number\n");
			return RET_SYN;
		}
		as = (natid) n;
	}
	if ((natp = getnatp(as)) == 0) {
		pr("Bad country number %d\n", player->cnum);
		return RET_SYN;
	}
	pr("\t%s Diplomatic Relations Report\t", cname(as));
	prdate();
#ifdef SLOW_WAR
	pr("\n  Formal Relations         %5s      theirs\n",
			player->cnum == as ? "yours" : "his");
#else
	pr("\n  Formal Relations         %5s     theirs\n",
			player->cnum == as ? "yours" : "his");
#endif /* SLOW_WAR */
	for (cn=1; cn < MAXNOC; cn++) {
		if ((np = getnatp(cn)) == 0)
			break;
		if (cn == as)
			continue;
		if ((np->nat_stat & STAT_NORM) == 0 &&
		    (np->nat_stat & STAT_SANCT) == 0)
			continue;
#ifdef	HIDDEN
		if (!player->god && !getcontact(natp, cn)) 
			continue;
#endif	/* HIDDEN */
		pr("%3d) %-20.20s  ", cn, cname(cn));
#ifdef SLOW_WAR
		pr("%-10s %s\n", relatename(natp, cn), relatename(np, as));
#else
		pr("%-9s %s\n", relatename(natp, cn), relatename(np, as));
#endif /* SLOW_WAR */
	}
	return RET_OK;
}
