/*
 * player.h
 *
 * per-player information
 *
 * Dave Pare, 1994
 */

#ifndef _PLAYER_H_
#define _PLAYER_H_

#include "queue.h"

#define COMHISTORY 10

struct player {
	struct qelem queue;
	struct lwpProc *proc;
	s_char	hostaddr[32];
	s_char	hostname[512];
	s_char	userid[32];
	int	validated;
	natid	cnum;
	int	state;
	struct comstr *command;
	struct iop *iop;
	s_char	combuf[512];
	s_char	comhistory[COMHISTORY][512]; /* not used */
	u_char	comhistoff;	/* not used -- index into above array */
	s_char	*argp[64];
	s_char	*condarg;
	long	lasttime;
	int	ncomstat;
	int	minleft;
	int	btused;
	int	visitor;
	int	god;
	int	owner;
	int	nstat;
	int	waiting;
	double  dolcost;
	int	broke;
	long	curup;                   /* used in calc of minutes used */
	int	aborted;
	int	bol;		/* XXX for pr */
	long	blitz_time;
	char	*map;			/* pointer to in-mem map */
	char	*bmap;			/* pointer to in-mem bmap */
};

#define PS_INIT		0
#define PS_LOGIN	1
#define PS_PLAYING	2
#define PS_SHUTDOWN	3
#define PS_KILL		4

/* thread priorities */
#define PP_UPDATE	5
#define PP_SHUTDOWN	4
#define PP_SCHED	3
#define PP_PLAYER	2
#define PP_ACCEPT	2
#define PP_KILLIDLE	1

extern struct player *player;		/* current player's context */

void		player_login();
void		player_main();
struct player	*player_new();
struct player	*player_delete();
struct player	*player_next();
struct player	*player_prev();
struct player	*getplayer();
struct player	*player_find_other();
s_char          *praddr();
void		player_accept();

#endif /* _PLAYER_H_ */
