static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/util/files.c,v 2.2 1995/07/27 00:31:57 empire Exp $";

/*
 * file.c
 *
 * create all the misc files except sctfil
 *
 * from PSL Empire, 1985
 */

#if defined(aix) || defined(linux)
#include <unistd.h>
#endif /* aix or linux */

#include <sys/types.h>
#include <fcntl.h>
#include <sys/uio.h>
#include <sys/file.h>
#include <stdio.h>

#include "options.h"
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "ship.h"
#include "land.h"
#include "plane.h"
#include "nuke.h"
#include "power.h"
#include "trade.h"
#include "file.h"
#include "tel.h"

s_char	program[] = "file";

main(argc, argv)
int argc;
char *argv[];
{
	extern	s_char *infodir;
	extern	s_char *commfil;
	extern	s_char *datadir;
	extern	struct empfile empfile[];
	s_char	buf[255];
	s_char   *filename;
	int	x,y;
	struct	natstr nat;
	struct	sctstr sct;
	int	i;
	s_char	*map;
	extern char *optarg;
	int opt;
	char *config_file = NULL;

	while ((opt = getopt (argc, argv, "e:")) != EOF) {
		switch (opt) {
			case 'e':
				config_file = optarg;
				break;
		}
	}

	emp_config (config_file);

	if (access(datadir, F_OK) < 0 && mkdir(datadir, 0750) < 0) {
		perror(datadir);
		printf("Can't make game directory\n");
		exit(1);
	}
	printf("WARNING: this blasts the existing game in %s (if any)\n", datadir);
	printf("continue? ");
	gets(buf);
	if (*buf != 'y' && *buf != 'Y')
		exit(1);
	for (i=0; i < EF_MAX; i++) {
		if (ef_open(i, O_RDWR|O_CREAT|O_TRUNC, 0) < 0) {
			perror("ef_open");
			exit(1);
		}
	}
	bzero(&nat, sizeof(nat));
	nat.ef_type = EF_NATION;
	if (nat.nat_cnam[0] == 0)
		strcpy(nat.nat_cnam,"POGO");
	if (nat.nat_pnam[0] == 0)
		strcpy(nat.nat_pnam,"peter");
	nat.nat_stat = STAT_INUSE|STAT_NORM|STAT_GOD|STAT_ABS;
	nat.nat_btu = 255;
	nat.nat_money = 123456789;
	nat.nat_cnum = 0;
	for(x=0;x<SCT_MAXDEF+8;x++)
		nat.nat_priorities[x] = -1;
	putnat((&nat));
	printf("All praise to %s!\n", nat.nat_cnam);
	bzero(&nat, sizeof(nat));
	for(x=0;x<SCT_MAXDEF+8;x++)
		nat.nat_priorities[x] = -1;
	for (i = 1; i < MAXNOC; i++) {
		nat.ef_type = EF_NATION;
		nat.nat_cnum = i;
		putnat((&nat));
	}
	ef_close(EF_NATION);
	comminit(make(commfil));
	for (x = MAXNOC - 1; x >= 0; x--) {
		filename = mailbox(buf, x);
		close(creat(filename, 0600));
		chmod(filename, 0600);
	}
	close(creat(annfil, 0600));
	chmod(infodir, 0750);
	chmod(datadir, 0770);

	/* create a zero-filled sector file */
	bzero(&sct,sizeof(sct));
	for (y=0;y<WORLD_Y;y++) {
		for (x=0;x<WORLD_X/2;x++) {
			sct_init(x*2 + (y & 01), y, &sct);
			putsect(&sct);
		}
	}
	map = (s_char *)calloc(WORLD_X*WORLD_Y/2, sizeof(*map));
	for (i=0; i < MAXNOC; i++) {
		ef_write(EF_MAP, i, map);
	}
	for (i=0; i < EF_MAX; i++) {
		ef_close(i);
	}

	exit(0);
}

quit()
{
	printf("bye-bye...\n");
}

int
make(filename)
	s_char   *filename;
{
	register int fd;

	fd = open(filename, O_RDWR|O_CREAT|O_TRUNC, 0600);
	if (fd < 0)
		printf("Creation of %s failed.\n", filename);
	return fd;
}


/*
 * commodity trading file special initialization
 */
float	comm[MAXNOC][I_MAX+1];
float	price[MAXNOC][I_MAX+1];
float	mult[MAXNOC][MAXNOC];

static	struct iovec tradevec[3] = {
	(caddr_t)comm,	sizeof(comm),
	(caddr_t)price,	sizeof(price),
	(caddr_t)mult,	sizeof(mult),
};

comminit(fd)
	int	fd;
{
	int	i;
	int	j;

	for (i=0; i<MAXNOC; i++)
		for (j=0; j<MAXNOC; j++)
			mult[i][j] = 1.0;
	writev(fd, tradevec, 3);
	close(fd);
}

/*ARGSUSED*/
s_char *
recvclient(cmd, buf)
	int	cmd;
	s_char	*buf;
{
	return gets(buf);
}

int
sct_init(x, y, ptr)
	coord	x, y;
	s_char	*ptr;
{
	struct	sctstr *sp = (struct sctstr *) ptr;

	sp->ef_type = EF_SECTOR;
	sp->sct_x = x;
	sp->sct_y = y;
	sp->sct_dist_x = x;
	sp->sct_dist_y = y;
}
