/*
 * bigmap.c
 *
 * updates player's sector map using sector
 * offsets and simple overwrite rules.
 */

#include "misc.h"
#include "player.h"
#include "file.h"

int
setmap(map, x, y, t, force)
	s_char	*map;
	coord	x, y;
	s_char	t;
	int	force;
{
	int	id;
	s_char	ot;

	if (t == '\0')
		return 0;
	if ((id = sctoff(x, y)) < 0)
		return 0;
	if (((map[id] == 'x') || (map[id] == 'X')) && !force)
		return 0;
	ot = map[id];
	if (t == '?') {
		switch (map[id]) {
		case '.':
		case '-':
		case ' ':
		case   0:
			map[id] = t;
			break;
		default:
			break;
		}
	} else {
		map[id] = t;
	}
	if (map[id] != ot)
		pr_mapsct(x, y, t);

	return 1;
}

int
msetmap(actor, x, y, t)
	natid	actor;
	coord	x, y;
	s_char	t;
{
	extern int update_pending;

	if (!update_pending && actor == player->cnum) 
		return setmap(player->map, x, y, t, 0);
	return setmap(ef_ptr(EF_MAP,actor), x, y, t, 0);
}
