/*
 * edb.h
 *
 * Empire DataBase defines--used for C_SYNC messages
 *
 * Ken Stevens, 1995
 */

#ifndef _EDB_H_
#define _EDB_H_

#include "toolkit.h"

#define EDB_VERS_MAJOR	0
#define EDB_VERS_MINOR	0
#define EDB_VERS_PATCH	1

struct edbstr {
	short	ef_type;
	int	edb_class;
	int	edb_object;
	int	edb_parent;
	struct	castr *edb_cf;	/* Class fields */
	struct	castr *edb_of;	/* Object fields */
	void	*edb_chr;	/* Pointer to the array of class structs */
	long	edb_last_var;	/* Does this object have var items? */
	int	edb_chrsize;	/* size of edb_chr struct */
	int	*edb_chrno;	/* pointer to number of elements in edb_chr */
	long	edb_last_com;	/* Does this class have var capacity? */
};

/* Visibility bitfields -- Which commands get to see which fields */
#define EDV_ALL		((long)0)
#define EDV_ID		((long)bit(1))
#define EDV_OWN		((long)bit(2))
#define EDV_XY		((long)bit(3))
#define EDV_TYPE	((long)bit(4))
#define EDV_EFF		((long)bit(5))
#define EDV_TECH	((long)bit(6))
#define EDV_CIV		((long)bit(7))
#define EDV_MIL		((long)bit(8))
#define EDV_SHL		((long)bit(9))
#define EDV_GUN		((long)bit(10))
#define EDV_PET		((long)bit(11))
#define EDV_FOOD	((long)bit(12))
#define EDV_BAR		((long)bit(13))
#define EDV_OLDOWN	((long)bit(14))
#define EDV_NEWTYPE	((long)bit(15))
#define EDV_LAST_VAR	((long)bit(16))
#define EDV_LAST_COMM	((long)bit(17))
#define EDV_MONEY	((long)bit(18))
#define EDV_LEVEL	((long)bit(19))

#define EDV_COAS (EDV_OWN | EDV_XY | EDV_TYPE)
#define EDV_LOOK (EDV_OWN | EDV_TYPE | EDV_EFF | EDV_CIV | EDV_MIL)
#define EDV_SPY (EDV_LOOK | EDV_SHL | EDV_GUN | EDV_PET | EDV_FOOD | EDV_BAR |\
		 EDV_NEWTYPE)

extern struct edbstr edbchr[];
extern struct castr sct_cf[];
extern struct castr shp_cf[];
extern struct castr pln_cf[];
extern struct castr lnd_cf[];
extern struct castr nuk_cf[];
extern struct castr map_cf[];
extern struct castr itm_cf[];
extern struct castr prd_cf[];
extern struct castr var_cf[];

#endif /* _EDB_H_ */
