#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/sect.c,v 2.8 1995/10/24 04:42:40 empire Exp $";
#endif

/*
 * sect.c
 *
 * post-read and pre-write sector data massage
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#include "land.h"
#include "nsc.h"
#include "plane.h"

/*ARGSUSED*/
int
sct_postread(ptr)
	s_char	*ptr;
{
	struct	sctstr *sp = (struct sctstr *) ptr;

	checksect(sp);
	player->owner = (player->god || sp->sct_own == player->cnum);
	return 1;
}

/*ARGSUSED*/
int
sct_prewrite(id, ptr)
	int	id;
	s_char	*ptr;
{
	struct	sctstr *sp = (struct sctstr *) ptr;

	checksect(sp);
}

checksect(sp)
struct	sctstr *sp;
{
	int	mil, civs, loyalcivs;
        struct  plnstr p2;
        int     old=sp->sct_own;
	struct	lndstr land;
	struct	nstr_item ni;

	/* shouldn't happen, but... */
	if (sp->sct_mobil > 127)
		sp->sct_mobil = 0;

	mil = getvar(V_MILIT, (s_char *)sp, EF_SECTOR);
	civs = getvar(V_CIVIL, (s_char *)sp, EF_SECTOR);
	if (sp->sct_own == sp->sct_oldown)
		loyalcivs = civs;
	else
		loyalcivs = 0;

	if (sp->sct_type == SCT_BSPAN && sp->sct_effic < 20) {
		sp->sct_type = SCT_WATER;
		sp->sct_newtype = SCT_WATER;
		sp->sct_own = 0;
		sp->sct_mobil = 0;
		sp->sct_oldown = 0;
		mpr(old, "A bridge span at %s has collapsed\n",
			xyas((int)sp->sct_x, (int)sp->sct_y, old));
                mpr(old, "Crumble... SCREEEECH!  Splash! Bridge falls at %s!\n", xyas(sp->sct_x, sp->sct_y, old));

		snxtitem_xy(&ni,EF_LAND,sp->sct_x,sp->sct_y);
		while(nxtitem(&ni,(s_char *)&land)){
			land.lnd_effic = 0;
			mpr(old, "     \007AARGH! %s tumbles to its doom!\n",
			    prland(&land));
			putland(land.lnd_uid,&land);
		}
		snxtitem_xy(&ni,EF_PLANE,sp->sct_x,sp->sct_y);
		while(nxtitem(&ni,(s_char *)&p2)){
			mpr(old, "     \007AARGH! %s tumbles to its doom!\n",
			    prplane(&p2));
			p2.pln_effic = 0;
			putplane(p2.pln_uid,&p2);
		}

		sp->sct_nv = 0;
	}
	if (sp->sct_own != 0 && !civs) {
		sp->sct_work = 100;
		sp->sct_oldown = sp->sct_own;
	}
	/* If they have a military unit there, they still own it */
	if (sp->sct_own && !loyalcivs) {
		if (!mil && !has_units(sp->sct_x,sp->sct_y,sp->sct_own)) {
			/* more cruft! */
			if (sp->sct_type == SCT_CAPIT ||
			    sp->sct_type == SCT_MOUNT)
				caploss(sp, sp->sct_own, "");

			if (sp->sct_oldown == sp->sct_own) {
				sp->sct_own = 0;
				sp->sct_oldown = 0;
			} else {
				/* if oldown gets his cap back make agri */
				if (sp->sct_oldown &&
				    player->cnum == sp->sct_own &&
				    sp->sct_type == SCT_CAPIT &&
				    sp->sct_newtype == SCT_CAPIT)
					give_back_cap(sp);
				takeover(sp, sp->sct_oldown);
			}
			sp->sct_mobil = 0;
		}
	}
	return 1;
}

issector(arg)
s_char *arg;
{
	s_char c;

	while (c = *arg++)
		if (!isdigit(c) && !isspace(c) && (c != '/'))
			return 1;

	return 0;
}

static
give_back_cap(sp)
	struct sctstr *sp;
{
	struct	natstr *natp = getnatp(sp->sct_oldown);

	if (xrel(natp,natp->nat_xcap) == xrel(natp,sp->sct_x) &&
	    yrel(natp,natp->nat_ycap) == yrel(natp,sp->sct_y)) {
		sp->sct_newtype = SCT_AGRI;
	}
}

int
sct_init(x, y, ptr)
	coord	x, y;
	s_char	*ptr;
{
	struct	sctstr *sp = (struct sctstr *) ptr;

	sp->ef_type = EF_SECTOR;
	sp->sct_x = x;
	sp->sct_y = y;
	sp->sct_dist_x = x;
	sp->sct_dist_y = y;
}
