#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/fileinit.c,v 2.2 1995/08/02 03:32:43 empire Exp $";
#endif /* not lint */

/*
 * fileinit.c
 *
 * Stuff that ef_init uses to initialize the
 * ca pointers and the pre/post i/o calls.
 * Only used by the client.
 *
 */

#include <fcntl.h>
#include "misc.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

extern	struct castr sect_ca[];
extern	struct castr news_ca[];
extern	struct castr loan_ca[];
extern	struct castr ship_ca[];
extern	struct castr plane_ca[];
extern	struct castr treaty_ca[];
extern	struct castr nuke_ca[];
extern	struct castr trade_ca[];

extern	int sct_init(), sct_postread(), sct_prewrite();
extern	int shp_init(), shp_postread(), shp_prewrite();
extern	int lnd_init(), lnd_postread(), lnd_prewrite();
extern	int pln_init(), pln_postread(), pln_prewrite();
extern	int nuk_init(), nuk_postread(), nuk_prewrite();

struct fileinit fileinit[EF_MAX] = {
	sct_init,	sct_postread,	sct_prewrite,	sect_ca,
	shp_init,	shp_postread,	shp_prewrite,	ship_ca,
	pln_init,	pln_postread,	pln_prewrite,	plane_ca,
	lnd_init,	lnd_postread,   lnd_prewrite,   land_ca,
	nuk_init,	nuk_postread,	nuk_prewrite,	nuke_ca,
	0,		0,		0,		news_ca,
	0,		0,		0,		treaty_ca,
	0,		0,		0,		trade_ca,
	0,		0,		0,		0, /* power */
	0,		0,		0,		0, /* nation */
	0,		0,		0,		loan_ca,
	0,		0,		0,		0, /* map */
};

ef_init()
{
	int	i;
	struct	empfile *ef;
	struct	fileinit *fi;

	ef = empfile;
	fi = fileinit;
	for (i=0; i<EF_MAX; i++, ef++, fi++) {
		ef->init = fi->init;
		ef->postread = fi->postread;
		ef->prewrite = fi->prewrite;
		ef->cadef = fi->cadef;
	}
}
