/*
 * edb.c
 *
 * This file contains the list of Empire objects which can be transmitted
 * using the C_SYNC protocol.
 * Class definitions may be found here, object definitions are in nsc.c
 *
 * Ken Stevens, 1995
 */

#include <struct.h>
#include "misc.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"
#include "edb.h"
#include "genitem.h"
#include "sect.h"
#include "ship.h"
#include "plane.h"
#include "land.h"
#include "news.h"
#include "nuke.h"
#include "treaty.h"
#include "item.h"
#include "product.h"
#include "optlist.h"
#include "nat.h"
#include "map.h"

struct edbstr edbchr[] = {
/* ef_type,	edb_class, edb_object, edb_parent, edb_cf, edb_ca,    chrstr */
EF_SECTOR,	SCT_CLASS, SCT_OBJECT, EDB_OBJECT, sct_cf, sect_ca,	dchr,
EDV_LAST_VAR, sizeof(struct dchrstr), &sct_maxno,0,
EF_SHIP,	SHP_CLASS, SHP_OBJECT, GEN_OBJECT, shp_cf, ship_ca,	mchr,
EDV_LAST_COMM, sizeof(struct mchrstr), &shp_maxno,EDV_LAST_COMM,
EF_PLANE,	PLN_CLASS, PLN_OBJECT, GEN_OBJECT, pln_cf, plane_ca,	plchr,
0, sizeof(struct plchrstr), &pln_maxno,0,
EF_LAND,	LND_CLASS, LND_OBJECT, GEN_OBJECT, lnd_cf, land_ca,	lchr,
EDV_LAST_COMM, sizeof(struct lchrstr), &lnd_maxno,EDV_LAST_COMM,
EF_NUKE,	NUK_CLASS, NUK_OBJECT, EDB_OBJECT, nuk_cf, nuke_ca,	nchr,0,
sizeof(struct nchrstr), &nuk_maxno,0,
EF_NEWS,	NWS_CLASS, NWS_OBJECT, EDB_OBJECT, 0, 0,	0,0,
0, 0,0,
EF_TREATY,	TRT_CLASS, TRT_OBJECT, EDB_OBJECT, 0, 0,	0,0,
0, 0,0,
EF_TRADE,	TRD_CLASS, TRD_OBJECT, EDB_OBJECT, 0, 0,0,0,0,0,0,
EF_POWER,	PWR_CLASS, PWR_OBJECT, EDB_OBJECT, 0, 0,0,0,0,0,0,
EF_NATION,	NAT_CLASS, NAT_OBJECT, EDB_OBJECT, 0, nat_ca, 0,0,0,0,0,
EF_LOAN,	LOA_CLASS, LOA_OBJECT, EDB_OBJECT, 0, 0, 0,0,0,0,0,
EF_MAP,		MAP_CLASS, MAP_OBJECT, EDB_OBJECT, map_cf, map_ca, 0,0,0,0,0,
EF_BAD,		ITM_CLASS, ITM_OBJECT, EDB_OBJECT, itm_cf, 0, ichr,0,
sizeof(struct ichrstr), &itm_maxno,0,
EF_BAD,		PRD_CLASS, PRD_OBJECT, EDB_OBJECT, prd_cf, 0, pchr,0,
sizeof(struct pchrstr), &prd_maxno,0,
EF_BAD,		VER_CLASS, VER_OBJECT, EDB_OBJECT, 0,0, 0,0,0,0,0,
EF_BAD,		GEN_CLASS, GEN_OBJECT, EDB_OBJECT, 0, genitem_ca,0,
EDV_LAST_COMM,0,0,0,
EF_BAD,		EDB_BAD,   EDB_BAD,    EDB_BAD, 0,      0,0,0,0,0,0,
};

struct castr	sct_cf[] = {
NSC_INT | fldoff(dchrstr, d_mnem), "mnem",0,0,
NSC_INT | fldoff(dchrstr, d_prd), "prd",0,0,
NSC_INT | fldoff(dchrstr, d_mcst), "mcst",0,0,
NSC_INT | fldoff(dchrstr, d_flg), "flg",0,0,
NSC_INT | fldoff(dchrstr, d_pkg), "pkg",0,0,
NSC_INT | fldoff(dchrstr, d_ostr), "ostr",0,0,
NSC_INT | fldoff(dchrstr, d_dstr), "dstr",0,0,
NSC_INT | fldoff(dchrstr, d_value), "value",0,0,
NSC_INT | fldoff(dchrstr, d_cost), "cost",0,0,
NSC_INT | fldoff(dchrstr, d_build), "build",0,0,
NSC_INT | fldoff(dchrstr, d_lcms), "lcms",0,0,
NSC_INT | fldoff(dchrstr, d_hcms), "hcms",0,0,
NSC_CHARP | fldoff(dchrstr, d_name), "name",20,0,
0,	0,	0,0
};

struct castr	shp_cf[] = {
NSC_INT | fldoff(mchrstr, m_lcm), "lcm",0,0,
NSC_INT | fldoff(mchrstr, m_hcm), "hcm",0,0,
NSC_INT | fldoff(mchrstr, m_armor), "armor",0,0,
NSC_INT | fldoff(mchrstr, m_speed), "speed",0,0,
NSC_INT | fldoff(mchrstr, m_visib), "visib",0,0,
NSC_INT | fldoff(mchrstr, m_vrnge), "vrnge",0,0,
NSC_INT | fldoff(mchrstr, m_frnge), "frnge",0,0,
NSC_INT | fldoff(mchrstr, m_glim), "glim",0,0,	
NSC_UCHAR | fldoff(mchrstr, m_nxlight), "nxlight",0,0,
NSC_UCHAR | fldoff(mchrstr, m_nchoppers), "nchoppers",0,0,
NSC_UCHAR | fldoff(mchrstr, m_fuelc), "fuelc",0,0,
NSC_UCHAR | fldoff(mchrstr, m_fuelu), "fuelu",0,0,
NSC_CHARP | fldoff(mchrstr, m_name), "name",20,0,
NSC_INT | fldoff(mchrstr, m_tech), "tech",0,0,	
NSC_INT | fldoff(mchrstr, m_cost), "cost",0,0,	
NSC_LONG | fldoff(mchrstr, m_flags), "flags",0,0,
NSC_UCHAR | fldoff(mchrstr, m_nplanes), "nplanes",0,0,
NSC_UCHAR | fldoff(mchrstr, m_nland), "nland",0,0,
0,	0,	0,0
};

struct castr	pln_cf[] = {
NSC_CHARP | fldoff(plchrstr, pl_name), "name",20,0,
NSC_INT | fldoff(plchrstr, pl_lcm), "lcm",0,0,		
NSC_INT | fldoff(plchrstr, pl_hcm), "hcm",0,0,
NSC_INT | fldoff(plchrstr, pl_cost), "cost",0,0,
NSC_INT | fldoff(plchrstr, pl_tech), "tech",0,0,	
NSC_INT | fldoff(plchrstr, pl_acc), "acc",0,0,		
NSC_INT | fldoff(plchrstr, pl_load), "load",0,0,	
NSC_INT | fldoff(plchrstr, pl_att), "att",0,0,		
NSC_INT | fldoff(plchrstr, pl_def), "def",0,0,
NSC_INT | fldoff(plchrstr, pl_range), "range",0,0,	
NSC_INT | fldoff(plchrstr, pl_crew), "crew",0,0,	
NSC_INT | fldoff(plchrstr, pl_fuel), "fuel",0,0,	
NSC_INT | fldoff(plchrstr, pl_stealth), "stealth",0,0,	
NSC_INT | fldoff(plchrstr, pl_flags), "flags",0,0,	
0,	0,	0,0
};

struct castr	lnd_cf[] = {
NSC_CHARP | fldoff(lchrstr, l_name), "name",20,0,
NSC_INT | fldoff(lchrstr, l_lcm), "lcm",0,0,
NSC_INT | fldoff(lchrstr, l_hcm), "hcm",0,0,
NSC_INT | fldoff(lchrstr, l_mil), "mil",0,0,
NSC_INT | fldoff(lchrstr, l_gun), "gun",0,0,
NSC_INT | fldoff(lchrstr, l_shell), "shl",0,0,
NSC_INT | fldoff(lchrstr, l_tech), "tech",0,0,
NSC_INT | fldoff(lchrstr, l_cost), "cost",0,0,
NSC_FLOAT | fldoff(lchrstr, l_att), "att",0,0,
NSC_FLOAT | fldoff(lchrstr, l_def), "def",0,0,
NSC_INT | fldoff(lchrstr, l_vul), "vul",0,0,
NSC_INT | fldoff(lchrstr, l_spd), "spd",0,0,
NSC_INT | fldoff(lchrstr, l_vis), "vis",0,0,
NSC_INT | fldoff(lchrstr, l_spy), "spy",0,0,
NSC_INT | fldoff(lchrstr, l_rad), "rad",0,0,
NSC_INT | fldoff(lchrstr, l_frg), "frg",0,0,
NSC_INT | fldoff(lchrstr, l_acc), "acc",0,0,
NSC_INT | fldoff(lchrstr, l_dam), "dam",0,0,
NSC_INT | fldoff(lchrstr, l_ammo), "ammo",0,0,
NSC_INT | fldoff(lchrstr, l_aaf), "aaf",0,0,
NSC_UCHAR | fldoff(lchrstr, l_fuelc), "fuelc",0,0,
NSC_UCHAR | fldoff(lchrstr, l_fuelu), "fuelu",0,0,
NSC_UCHAR | fldoff(lchrstr, l_nxlight), "nxlight",0,0,
NSC_LONG | fldoff(lchrstr, l_flags), "flags",0,0,
0,	0,	0,0
};

struct castr	nuk_cf[] = {
NSC_CHARP | fldoff(nchrstr, n_name),"name",20,0,
NSC_INT | fldoff(nchrstr, n_lcm),"lcm",0,0,
NSC_INT | fldoff(nchrstr, n_hcm),"hcm",0,0,
NSC_INT | fldoff(nchrstr, n_oil),"oil",0,0,
NSC_INT | fldoff(nchrstr, n_rad),"rad",0,0,
NSC_INT | fldoff(nchrstr, n_blast),"blast",0,0,
NSC_INT | fldoff(nchrstr, n_dam),"dam",0,0,
NSC_INT | fldoff(nchrstr, n_cost),"cost",0,0,
NSC_INT | fldoff(nchrstr, n_tech),"tech",0,0,
NSC_INT | fldoff(nchrstr, n_weight),"weight",0,0,
NSC_INT | fldoff(nchrstr, n_flags),"flags",0,0,
0,	0,	0,0
};

struct castr	map_cf[] = {
NSC_XCOORD | fldoff(mapsct, map_x),"x",0,0,
NSC_XCOORD | fldoff(mapsct, map_y),"y",0,0,
NSC_CHAR | fldoff(mapsct, map_des),"des",0,0
};

struct castr	itm_cf[] = {
NSC_INT | fldoff(ichrstr, i_mnem),"mnem",0,0,
NSC_INT | fldoff(ichrstr, i_value),"value",0,0,
NSC_INT | fldoff(ichrstr, i_sell),"sell",0,0,
NSC_INT | fldoff(ichrstr, i_lbs),"lbs",0,0,
NSC_INT | fldoff(ichrstr, i_pkg[0]),"pkg",NUMPKG,0,
NSC_CHARP | fldoff(ichrstr, i_name),"name",20,0,
0,	0,	0,0
};

struct castr	prd_cf[] = {
NSC_INT | fldoff(pchrstr, p_cost),"cost",0,0,
NSC_INT | fldoff(pchrstr, p_nrndx),"nrndx",0,0,
NSC_INT | fldoff(pchrstr, p_nrdep),"nrdep",0,0,
NSC_INT | fldoff(pchrstr, p_nlndx),"nlndx",0,0,
NSC_INT | fldoff(pchrstr, p_nlmin),"nlmin",0,0,
NSC_INT | fldoff(pchrstr, p_nllag),"nllag",0,0,
NSC_INT | fldoff(pchrstr, p_effic),"effic",0,0,
NSC_CHARP | fldoff(pchrstr, p_name),"name",20,0,
NSC_CHARP | fldoff(pchrstr, p_sname),"sname",7,0,
0,	0,	0,0
};
