#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/togg.c,v 2.3 1995/10/01 22:35:19 empire Exp $";
#endif /* not lint */

/*
 * togg.c
 *
 * Set player flags
 *
 * Ken Stevens 1995
 */

#include "misc.h"
#include "player.h"
#include "file.h"
#include "nat.h"

togg()
{
	int	flag = 0;
	int	pos;
	s_char	*name;
	struct	natstr *np;

	np = getnatp(player->cnum);
	if (player->argp[1]) {
		switch (*player->argp[1]) {
		case 'a':
			name = "async"; flag = NF_ASYNC; break;
		case 'i':
			name = "inform"; flag = NF_INFORM; break;
		case 'f':
			name = "flash"; flag = NF_FLASH; break;
		case 'b':
			name = "beep"; flag = NF_BEEP; break;
		case 'c':
			name = "coastwatch"; flag = NF_COASTWATCH; break;
		case 's':
			if (player->argp[1][1] == 'o') {
				name = "sonar"; flag = NF_SONAR; break;
			} else {
				name = "sync"; flag = NF_SYNC; break;
			}
		default:
			return RET_SYN;
		}
		if (player->argp[2])
			if (!strcmp(player->argp[2], "on"))
				pos = 1;
			else if (!strcmp(player->argp[2], "off"))
				pos = 0;
			else
				return RET_SYN;
		else
			pos = ~(np->nat_flags & flag);
		if (pos)
			np->nat_flags |= flag;
		else
			np->nat_flags &= ~flag;
		putnat(np);
		pr("%s flag %s\n", name, pos?"on":"off");
	} else {
		if (np->nat_flags & NF_INFORM)
			pr("inform flag on\n");
		else
			pr("inform flag off\n");
		if (np->nat_flags & NF_FLASH)
			pr("flash flag on\n");
		else
			pr("flash flag off\n");
		if (np->nat_flags & NF_BEEP)
			pr("beep flag on\n");
		else
			pr("beep flag off\n");
		if (np->nat_flags & NF_COASTWATCH)
			pr("coastwatch flag on\n");
		else
			pr("coastwatch flag off\n");
		if (np->nat_flags & NF_SONAR)
			pr("sonar flag on\n");
		else
			pr("sonar flag off\n");
		if (np->nat_flags & NF_SYNC)
			pr("sync flag on\n");
		else
			pr("sync flag off\n");
		if (np->nat_flags & NF_ASYNC)
			pr("async flag on\n");
		else
			pr("async flag off\n");
	}

	return RET_OK;
}
