#ifndef _OPTLIST_H_
#define _OPTLIST_H_

#include "prototype.h"

struct option_list {
    char *opt_key;
    int  *opt_valuep;
};

extern struct option_list Options[];

extern void set_option _PROTO((const char *key));
extern void delete_option _PROTO((const char *key));

extern int opt_NOFOOD;
extern int opt_SNEAK_ATTACK;
extern int opt_BLITZ;
extern int opt_NEWPAF;
extern int opt_HIDDEN;
extern int opt_LOSE_CONTACT;
extern int opt_NONUKES;
extern int opt_FUEL;
extern int opt_TRADESHIPS;
extern int opt_NEWPOWER;
extern int opt_NOMOBCOST;
extern int opt_SUPER_BARS;
extern int opt_EASY_BRIDGES;
extern int opt_ALL_BLEED;
extern int opt_DRNUKE;
extern int opt_SLOW_WAR;
extern int opt_NO_PLAGUE;
extern int opt_NEW_STARVE;
extern int opt_NEW_WORK;
extern int opt_RES_POP;
extern int opt_GRAB_THINGS;
extern int opt_SHOWPLANE;
extern int opt_ORBIT;
extern int opt_PINPOINTMISSILE;
extern int opt_FALLOUT;
extern int opt_SAIL;		/* not used currently */
extern int opt_NUKEFAILDETONATE;
extern int opt_MISSINGMISSILES;
extern int opt_SHIPNAMES;	/* not used currently */
extern int opt_NEUTRON;
extern int opt_UPDATESCHED;
extern int opt_DEMANDUPDATE;
extern int opt_BIG_CITY;
extern int opt_INTERDICT_ATT;

struct keymatch;		/* forward decl */

/* function prototype for variable setting routines */
typedef void KmFunc _PROTO((struct keymatch *kp, s_char **av));

/* current known routines */
#if defined(__cplusplus) || (defined(__STDC__) &&__STDC__)
KmFunc strset, intset, floatset, doubleset, longset, 
	optionset, optiondel;
#else
void strset(), intset(), floatset(), doubleset(), longset(), 
	optionset(), optiondel();
#endif

struct keymatch {
	s_char *km_key;		/* the key */
	KmFunc *km_func;	/* the function to call if matches */
	caddr_t km_data;	/* associated data */
	int km_flags;		/* useful flags */
#define KM_ALLOC	0x01	/* memory allocated */
};

static struct keymatch *keylookup _PROTO((s_char *key, struct keymatch tbl[]));

extern struct keymatch configkeys[];

#endif /* _OPTLIST_H_ */
