/*
 * nuke.h
 *
 * things having to do with nukes
 *
 * Dave Pare, 1986
 * $Revision: 2.1 $ $Date: 1995/07/27 20:52:12 $
 */

#ifndef _NUKE_H_
#define _NUKE_H_

#define	N_MAXNUKE	15

struct	nukstr {
	short	ef_type;
	coord	nuk_x;		/* current loc of device */
	coord	nuk_y;
	natid	nuk_own;
	s_char	nuk_n;		/* number of nukes in list */
	short	nuk_uid;
	short	nuk_ship;	/* currently aboard ship */
	short	nuk_trade;	/* index into trade file */
	s_char	nuk_types[N_MAXNUKE];	/* # of nukes in sector of given type */
};

struct nchrstr {
	s_char *n_name;		/* warhead unit name */
	int n_lcm;		/* costs to build */
	int n_hcm;
	int n_oil;
	int n_rad;
	int n_blast;		/* blast radius */
	int n_dam;		/* damage at center */
	int n_cost;
	int n_tech;		/* tech needed to build */
	int n_weight;
	int n_flags;		/* description of capability */
};

#define	N_NEUT	bit(0)		/* Neutron bomb (low damage, high fallout) */

#define getnuke(n, p) \
	ef_read(EF_NUKE, n, (caddr_t)p)
#define putnuke(n, p) \
	ef_write(EF_NUKE, n, (caddr_t)p)
#define getnukep(n) \
	(struct nukstr *) ef_ptr(EF_NUKE, n)

extern  struct nchrstr nchr[];

extern	int nuk_maxno;

#endif /* _NUKE_H_ */
