#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/server/shutdown.c,v 2.2 1995/10/11 03:12:44 empire Exp $";
#endif

/*
 * shutdown.c
 *
 * Shuts down server.  Runs at low priority.
 *
 * Ken Stevens, 1995
 */

#include "misc.h"
#include "player.h"
#include "io.h"
#include "lwp.h"
#include "proto.h"
#include "nat.h"
#include "file.h"
#include <time.h>

int shutdown_pending;

void
shutdown_init()
{
	shutdown_pending = 0;
}

void
shutdown_sequence(argc, argv)
	int	argc;
	s_char	**argv;
{
	struct	player *p;
	struct	natstr *god;
	struct tm *tm;
	time_t	now;
	s_char header[100];

	if (shutdown_pending <= 0) {
		shutdown_pending = 0;
		logerror("shutdown called with 0 shutdown_pending");
		lwpExit();
		return;
	}
	god = getnatp(0);
	while (shutdown_pending > 0) {
		--shutdown_pending;
		time(&now);
		if (shutdown_pending <= 1440) { /* one day */
			tm = localtime(&now);
			sprintf(header, "BROADCAST from %s @ %02d:%02d: ",
				god->nat_cnam, tm->tm_hour, tm->tm_min);
			if (!shutdown_pending) {
				pr_wall("%sServer shutting down NOW!\n", header);
				shutdwn(0);
			} else if (shutdown_pending == 1) {
				pr_wall("%sServer shutting down in 1 minute!\n", header);
			} else if (shutdown_pending <= 5) {
				pr_wall("%sServer shutting down in %d minutes!\n", header, shutdown_pending);
			} else if (shutdown_pending <= 60 &&
				   shutdown_pending%10 == 0) {
				pr_wall("%sThe server will be shutting down in %d minutes!\n", header, shutdown_pending);
			} else if (shutdown_pending%60 == 0) {
				pr_wall("%sThe server will be shutting down %d hours from now.\n", header, (int)(shutdown_pending/60));
			}
		}
		lwpSleepUntil(now + 60);
	}
	lwpExit();
}

