#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/update/main.c,v 2.3 1995/10/11 03:05:54 empire Exp $";
#endif

/*
 * main.c
 *
 * world update main
 *
 * Dave Pare, 1994
 */

#include "misc.h"
#include "nat.h"
#include "file.h"
#include "sect.h"
#include "player.h"
#include "lwp.h"
#include "var.h"
#include "budg.h"
#include "edb.h"

#include <sys/time.h>

long	money[MAXNOC];
long	pops[MAXNOC];
long	sea_money[MAXNOC];
long	lnd_money[MAXNOC];
long	air_money[MAXNOC];

extern  int mil_dbl_pay;

/*ARGSUSED*/
void
update_main(argc, argv)
	int	argc;
	s_char	**argv;
{
	extern	int etu_per_update;
	extern	double money_res;
	int	etu = etu_per_update;
	int	n;
	int	x;
	int     *bp;
#ifdef SLOW_WAR
	int	cn,cn2,rel;
	struct	natstr *cnp;
#endif /* SLOW_WAR */
	struct	natstr *np;

	player->proc = LwpCurrent;
	player->cnum = 0;
	player->god = 1;
	/*
	 * set up all the variables which get used in the
	 * sector production routine (for producing education,
	 * happiness, and printing out the state of the nation)
	 */
	logerror("production update (%d etus)", etu);
	bzero((s_char *)pops, sizeof(pops));
	bzero((s_char *)air_money, sizeof(air_money));
	bzero((s_char *)sea_money, sizeof(sea_money));
	bzero((s_char *)lnd_money, sizeof(lnd_money));
	bp = (int *) calloc(WORLD_X * WORLD_Y * 7, sizeof(int));
	for (n=0; n<MAXNOC; n++) {
		money[n] = 0;
		if ((np = getnatp(n)) == (struct natstr *)0)
			continue;
		money[n] = np->nat_money;
	}
	prepare_sects(etu, bp);
	for (x=0; x<MAXNOC; x++){
		int	y,z,sb=0,sm=0,pb=0,pm=0,lm=0,lb=0;

		mil_dbl_pay = 0;
		if ((np = getnatp(x)) == (struct natstr *)0)
			continue;
                if (np->nat_stat & STAT_SANCT ) {
#ifdef DEBUG
		   logerror("Country %i is in sanctuary and did not update",x);
#endif
		   continue;
		} 
		np->nat_money += (int) (np->nat_reserve * money_res);
		for(y=1; y<SCT_MAXDEF+8; y++) {
			for(z=0; z<SCT_MAXDEF+8; z++) {
				if (np->nat_priorities[z] == y)
					do_prod(z, etu, x, bp, &sb, &sm, &pb, 
						&pm, &lb, &lm);
			}
		}
		/* 0 is maintain, 1 is build */
		if (!sm) prod_ship(etu, x, bp, 0);
		if (!sb) prod_ship(etu, x, bp, 1);
		if (!pm) prod_plane(etu, x, bp, 0);
		if (!pb) prod_plane(etu, x, bp, 1);
		if (!lm) prod_land(etu, x, bp, 0);
		if (!lb) prod_land(etu, x, bp, 1);
		/* produce all sects that haven't produced yet */
		produce_sect(x, etu, -1);
	}
	finish_sects();
	prod_nat(etu);
	age_levels(etu);
	free(bp);
	/*flushwu();*/
#ifdef SLOW_WAR
	/* Update war declarations */
	/* MOBILIZATION->SITZKRIEG->AT_WAR */
	for (cn=1; cn < MAXNOC; cn++) {
		if ((cnp = getnatp(cn)) == 0)
			break;
		for (cn2=1; cn2 < MAXNOC; cn2++) {
			if (cn2 == cn)
				continue;
			rel=getrel(cnp,cn2);
			if (rel == MOBILIZATION){
			    rel = SITZKRIEG;
			    setrel(cn,cn2,rel);
			}
			else if (rel == SITZKRIEG){
			    rel = AT_WAR;
			    setrel(cn,cn2,rel);
			}
		}
	}
#endif /* SLOW_WAR */
	mob_ship(etu);
	mob_sect(etu);
	mob_plane(etu);
	mob_land(etu);
#ifdef DEMANDUPDATE
	update_removewants();
#endif /* DEMANDUPDATE */
	/* flush all mem file objects to disk */
	ef_flush(EF_NATION);
	ef_flush(EF_SECTOR);
	ef_flush(EF_SHIP);
	ef_flush(EF_PLANE);
	ef_flush(EF_LAND);
	delete_old_announcements();
	inform_countries();
	logerror("End update");
	player_delete(player);
	lwpExit();
	/*NOTREACHED*/
}

do_prod(sector_type,etu,n,bp,ship_build,ship_maint,plane_build,plane_maint,land_build,land_maint)
	int sector_type;
	int n,*bp,*ship_build,*ship_maint;
	int *plane_build,*plane_maint;
	int *land_build,*land_maint;
{
        extern double money_mil;
	struct natstr *np;

	np = getnatp(n);

	if (sector_type == PRI_SMAINT){
		prod_ship(etu,n,bp,0);
		*ship_maint=1;
	}
	else
	if (sector_type == PRI_SBUILD){
		prod_ship(etu,n,bp,1);
		*ship_build=1;
	}
	else
	if (sector_type == PRI_PMAINT){
		prod_plane(etu,n,bp,0);
		*plane_maint=1;
	}
	else
	if (sector_type == PRI_PBUILD){
		prod_plane(etu,n,bp,1);
		*plane_build=1;
	}
	else
	if (sector_type == PRI_LMAINT){
	        if (*land_build)
		  np->nat_money -= (int) (money_mil * etu * mil_dbl_pay);
		prod_land(etu,n,bp,0);
		*land_maint=1;
	}
	else
	if (sector_type == PRI_LBUILD){
		prod_land(etu,n,bp,1);
		*land_build=1;
	}
	else
		produce_sect(n,etu,sector_type);
}

static
inform_countries()
{
	natid	to;
	struct	natstr	*np;

	for (to = 0; np = getnatp(to); ++to) {
		if (!(np->nat_stat & STAT_NORM))
			continue;

		pr_async(np->nat_cnum, "%d\n", EDB_UPDATE);
	}
}
