#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/trechk.c,v 2.0 1995/01/25 19:58:54 empire Exp $";
#endif

/*
 * trechk.c
 *
 * Check to see if an actor has a treaty forbidding a given action,
 * and if so, see if the actor wishes to break the treaty.
 * All applicable treaties are checked.  All treaties must be broken
 * if the action is to be allowed.  Propsed treaties are warned about,
 * but no mention of broken pending treaties are made in the news.
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "treaty.h"
#include "nat.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"

int
trechk(actor, victim, provision)
	register natid actor;
	register natid victim;
	int     provision;
{
	register natid cn;
	s_char	buf[1024];
	int	news_verb;
	int	involved[MAXNOC];
	struct	trtstr treaty;
	time_t	now;
	int	conditions;
	natid	other;
	int	broken;
	int	applied;
	struct	nstr_item nstr;

	(void) time(&now);
	broken = 0;
	applied = 0;
	for (cn = 0; cn < MAXNOC; cn++)
		involved[cn] = 0;
	snxtitem_all(&nstr, EF_TREATY);
	while (nxtitem(&nstr, (s_char *)&treaty)) {
		if (treaty.trt_status == TS_FREE)
			continue;
		if (treaty.trt_exp < now)
			continue;
		if (actor == treaty.trt_cna) {
			conditions = treaty.trt_acond;
			other = treaty.trt_cnb;
		} else if (actor == treaty.trt_cnb) {
			conditions = treaty.trt_bcond;
			other = treaty.trt_cna;
		} else
			continue;
		if ((conditions & provision) == 0)
			continue;
		/* victim=0 for no new nukes, no enlistment, etc. */
		if (victim != other && victim != 0)
			continue;
		/* treaty applies to actor */
		applied++;
		pr("This action is in contravention of ");
		if (treaty.trt_status == TS_PROPOSED)
			pr("pending ");
		pr(" treaty #%d (with %s)\n", nstr.cur, cname(other));
		getstring("Do you wish to go ahead anyway? (yes/no) ", buf);
		if (*buf == 'n' || *buf == 'N')
			broken = 0;
		else
			broken = 1;
		if (treaty.trt_status == TS_SIGNED)
			involved[other]++;
	}
	if (applied > 0) {
		news_verb = N_HONOR_TRE;
		if (broken > 0)
			news_verb = N_VIOL_TRE;
		for (cn=0; cn < MAXNOC; cn++)
			if (involved[cn] > 0)
				nreport(actor, news_verb, cn, 1);
	}
	if (applied && !broken) {
		/*
		 * if any treaty applied, and none were broken
		 * the intended action is NOT performed.
		 */
		return 0;
	}
	return 1;
}
