#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/trdsub.c,v 2.3 1995/10/11 03:00:05 empire Exp $";
#endif /* not lint */

/*
 * trdsub.c
 *
 * trade helper routines
 *
 * St Phil, 1989
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "item.h"
#include "ship.h"
#include "land.h"
#include "nuke.h"
#include "plane.h"
#include "trade.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"


s_char *
trade_nameof(tp, tgp)
	struct	trdstr *tp;
	union	trdgenstr *tgp;
{
	switch (tp->trd_type) {
	case EF_NUKE:
		return "nuclear stockpile";
	case EF_PLANE:
		return plchr[tgp->pln.pln_type].pl_name;
	case EF_SHIP:
		return mchr[tgp->shp.shp_type].m_name;
	case EF_LAND:
		return lchr[tgp->lnd.lnd_type].l_name;
	}
	return "Bad trade type, get help";
}

/*
 * Describe an item up for sale.  "tgp" is a union containing
 * the details of the generic item.
 * Return 1 on success, 0 on error
 */
trade_desc(tp, tgp)
	struct	trdstr *tp;
	union	trdgenstr *tgp;
{
	int	i;
	float	price;
	struct	sctstr sect;
	struct	nukstr *np;
	struct	shpstr *sp;
	struct	plnstr *pp;
	struct	lndstr *lp;
	struct	natstr *natp;
	int	needcomma;
#ifdef	SHOWPLANE
	struct  nstr_item ni;
	struct  plnstr plane;
	struct  lndstr land;
#endif	/* SHOWPLANE */

	price = multread(tp->trd_owner, player->cnum) * tp->trd_price;
	switch (tp->trd_type) {
	case EF_NUKE:
		np = &tgp->nuk;
		if (!getsect(np->nuk_x, np->nuk_y, &sect))
			return 0;
		tp->trd_owner = sect.sct_own;
		natp = getnatp(tp->trd_owner);
		pr("(#%3d)  %8.8s  %10.2f   ", sect.sct_own,
			natp->nat_cnam, price);
		needcomma = 0;
		for (i = 0; i < N_MAXNUKE; i++) {
			if (np->nuk_types[i]) {
				if (needcomma)
					pr(",");
				pr("%dx%s", np->nuk_types[i], nchr[i].n_name);
				needcomma = 1;
			}
		}
		break;
	case EF_SHIP:
		sp = &tgp->shp;
		tp->trd_owner = sp->shp_own;
		pr("(#%3d)  %8.8s  %10.2f   tech %d %d%% %s [",
		   tp->trd_owner, cname(tp->trd_owner),
		   price,
		   sp->shp_tech,
		   sp->shp_effic,
		   prship(sp));

		for (i = 0; i < sp->shp_nv; i++) {
			pr("%c:%d ",
				ichr[sp->shp_vtype[i] & ~VT_TYPE].i_mnem,
				sp->shp_vamt[i]);
		}
		pr("] #%d", tp->trd_unitid);
#ifdef	SHOWPLANE
		snxtitem_all(&ni, EF_PLANE);
		while (nxtitem(&ni, (s_char *)&plane))
		{
		    if (plane.pln_ship == sp->shp_uid)
		    {
			pr("\n\t\t\t\t    tech %3d %3d%% %s #%d",
			    plane.pln_tech,
			    plane.pln_effic,
			    plchr[plane.pln_type].pl_name,
			    plane.pln_uid);
			if (plane.pln_nuketype != (s_char)-1)
			{
			    pr("(%s)",nchr[plane.pln_nuketype].n_name);
			}
		    }
		}
		snxtitem_all(&ni, EF_LAND);
		while (nxtitem(&ni, (s_char *)&land))
		{
		    if (land.lnd_ship == sp->shp_uid)
		    {
			pr("\n\t\t\t\t    tech %3d %3d%% %s #%d",
			    land.lnd_tech,
			    land.lnd_effic,
			    lchr[land.lnd_type].l_name,
			    land.lnd_uid);
			if (land.lnd_nxlight)
			{
				snxtitem_all(&ni, EF_PLANE);
				while (nxtitem(&ni, (s_char *)&plane))
				{
		    			if (plane.pln_land == land.lnd_uid)
		    			{
						pr("\n\t\t\t\t    tech %3d %3d%% %s #%d",
			    			plane.pln_tech,
			    			plane.pln_effic,
			    			plchr[plane.pln_type].pl_name,
			    			plane.pln_uid);
						if (plane.pln_nuketype != (s_char)-1)
						{
			    			pr("(%s)",
							nchr[plane.pln_nuketype].n_name);
						}
		    			}
				}
			}
		    }
		}
#endif	/* SHOWPLANE */
		getsect(sp->shp_x, sp->shp_y, &sect);
		if (sect.sct_type != SCT_WATER)
			pr(" in a %s %s", cname(sect.sct_own),
				dchr[sect.sct_type].d_name);
		else
			pr(" at sea");
		break;
	case EF_LAND:
		lp = &tgp->lnd;
		tp->trd_owner = lp->lnd_own;
		pr("(#%3d)  %8.8s  %10.2f   tech %d %d%% %s [",
			tp->trd_owner, cname(tp->trd_owner),
			price,
			lp->lnd_tech,
			lp->lnd_effic,
			lchr[lp->lnd_type].l_name);

		for (i = 0; i < lp->lnd_nv; i++) {
			pr("%c:%d ",
				ichr[lp->lnd_vtype[i] & ~VT_TYPE].i_mnem,
				lp->lnd_vamt[i]);
		}
		pr("] #%d", tp->trd_unitid);
#ifdef	SHOWPLANE
		snxtitem_all(&ni, EF_PLANE);
		while (nxtitem(&ni, (s_char *)&plane))
		{
		    if (plane.pln_land == lp->lnd_uid)
		    {
			pr("\n\t\t\t\t    tech %3d %3d%% %s #%d",
			    plane.pln_tech,
			    plane.pln_effic,
			    plchr[plane.pln_type].pl_name,
			    plane.pln_uid);
			if (plane.pln_nuketype != (s_char)-1)
			{
			    pr("(%s)",
				nchr[plane.pln_nuketype].n_name);
			}
		    }
		}
#endif	/* SHOWPLANE */
		getsect(lp->lnd_x, lp->lnd_y, &sect);
		break;
	case EF_PLANE:
		pp = &tgp->pln;
		tp->trd_owner = pp->pln_own;
		pr("(#%3d)  %8.8s  %10.2f   tech %d %d%% %s #%d",
			tp->trd_owner, cname(tp->trd_owner),
			price,
			pp->pln_tech,
			pp->pln_effic,
			plchr[pp->pln_type].pl_name,
			tp->trd_unitid);
		if (pp->pln_nuketype != (s_char)-1) {
			pr("(%s)", 
				nchr[pp->pln_nuketype].n_name);
		}
		break;
	default:
		pr("flaky unit type %d", tp->trd_type);
		break;
	}
	return 1;
}

int
trade_getitem(tp, tgp)
	struct	trdstr *tp;
	union	trdgenstr *tgp;
{
	if (!ef_read(tp->trd_type, tp->trd_unitid, (s_char *)tgp))
		return 0;
	return 1;
}
