#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/caploss.c,v 2.4 1995/10/22 20:49:21 empire Exp $";
#endif

/*
 * caploss.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "nat.h"
#include "var.h"
#include "sect.h"
#include "file.h"
#include "xy.h"
#include "news.h"
#include "path.h"
#include "edb.h"

void
caploss(sp, coun, msg)
	struct	sctstr *sp;
	natid	coun;
	s_char	*msg;
{
	struct	natstr *natp;
	long	lose;
	long	gain;
	struct	sctstr sect;
	int	n;

	natp = getnatp(coun);
	if ((xrel(natp,natp->nat_xcap) != xrel(natp,sp->sct_x)) ||
	      (yrel(natp,natp->nat_ycap) != yrel(natp,sp->sct_y)))
	     return;
	pr(msg, natp->nat_cnam);
	if (coun == player->cnum) {
		player->nstat &= ~CAP;
		return;
	}
	if (sp->sct_updated == 1){
		gain = lose = natp->nat_money / 2;
		if (lose < 3000)
			lose = 3000;
		n = roll(6);
		getsect(sp->sct_x + diroff[n][0],
			sp->sct_y + diroff[n][1],
			&sect);
		natp->nat_xcap = sect.sct_x;
		natp->nat_ycap = sect.sct_y;
		natp->nat_money -= lose;
		putnat(natp);
		prsync(natp->nat_cnum, natp, EDV_ALL);
		wu(0, coun,
		   "* %s just sacked your capital! *\n",
		   cname(player->cnum));
		   
		if (gain >= 0)  {
			gain = (0.2 + 0.8 * (sp->sct_effic/100.0)) * gain;
			player->dolcost -= gain;
		} else
			gain = 0;
		wu(0, coun,
		   "You lost $%d and they gained $%d\n",
		   lose, gain);
		wu(0, coun,
		   "Your capital has been moved to %s\n",
		   xyas(natp->nat_xcap, natp->nat_ycap, coun));
		wu(0, 0, "%s just took %s's capital and gained $%d\n",
			cname(player->cnum), cname(coun),
			-(int)(player->dolcost));
		nreport(player->cnum, N_SACK_CAP, coun, 1);
		sp->sct_updated = 0;
	}
}
