/*
 * bigmap.c
 *
 * updates player's sector map using sector
 * offsets and simple overwrite rules.
 */

#include "misc.h"
#include "player.h"
#include "file.h"

/* values of only_bmap:
 * 0 = update both maps
 * 1 = update only bmap
 * 2 = update only bmap with force
 */

static int
do_map_set();

int
map_set(cnum, x, y, t, only_bmap)
	natid	cnum;
	coord	x, y;
	s_char	t;
	int	only_bmap;
{
	int	set = 0;

	if (!t)
		return 0;
	if (!only_bmap)
		set |= do_map_set(cnum, ef_ptr(EF_MAP,cnum), x,y, t, 0, 0);
	set |= do_map_set(cnum, ef_ptr(EF_BMAP,cnum),x,y, t, only_bmap > 1, 1);

	return set;
}


static int
do_map_set(cnum, map, x, y, t, force, sync)
	natid	cnum;
	s_char	*map;
	coord	x, y;
	s_char	t;
	int	force;
	int	sync;
{
	int	id;
	s_char	ot;

	if ((id = sctoff(x, y)) < 0)
		return 0;

	if (((map[id] == 'x') || (map[id] == 'X')) && !force)
		return 0;

	ot = map[id];
	if (t == '?') {
		switch (map[id]) {
		case '.':
		case '-':
		case ' ':
		case   0:
			map[id] = t;
			break;
		default:
			break;
		}
	} else {
		map[id] = t;
	}
	if (sync && map[id] != ot)
		pr_mapstr(cnum, x, y, t);

	return 1;
}

writebmap(cnum)
	natid	cnum;
{
	ef_write(EF_BMAP, cnum, ef_ptr(EF_BMAP,cnum));
}

writemap(cnum)
	natid	cnum;
{
	ef_write(EF_MAP, cnum, ef_ptr(EF_MAP,cnum));
	ef_write(EF_BMAP, cnum, ef_ptr(EF_BMAP,cnum));
}
