#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/gen/lock.c,v 2.0 1995/07/27 05:56:17 empire Exp $";
#endif

/*
 * lock.c
 *
 * lock a file
 *
 */

#ifdef aix
#define L_SET 0
#endif /* aix */

#include "misc.h"
#include <fcntl.h>

#ifdef sys5
#include <unistd.h>
#endif
#ifndef L_SET
#include <sys/file.h>
#endif

#ifdef aix
#define L_SET 0
#endif /* aix */

#ifndef NOFLOCK

int
file_lock(fd)
	int	fd;
{
	if (flock(fd, LOCK_EX) < 0) {
		logerror("file lock (fd %d) failed", fd);
		return 0;
	}
	return 1;
}

int
file_unlock(fd)
	int	fd;
{
	if (flock(fd, LOCK_UN) < 0) {
		logerror("file unlock (fd %d) failed", fd);
		return 0;
	}
	return 1;
}

#else

int
file_lock(fd)
	int	fd;
{
	struct	flock lock;

	lock.l_type = F_WRLCK;
	lock.l_whence = L_SET;
	lock.l_start = 0;
	lock.l_len = 0;
	lock.l_pid = 0;
	if (fcntl(fd, F_SETLKW, &lock) < 0) {
		logerror("file lock (fd %d) failed", fd);
		return 0;
	}
	return 1;
}

int
file_unlock(fd)
	int	fd;
{
	struct	flock lock;

	lock.l_type = F_UNLCK;
	lock.l_whence = L_SET;
	lock.l_start = 0;
	lock.l_len = 0;
	lock.l_pid = 0;
	if (fcntl(fd, F_SETLKW, &lock) < 0) {
		logerror("file unlock (fd %d) failed", fd);
		return 0;
	}
	return 1;
}
#endif
