#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/thre.c,v 2.0 1995/01/25 19:23:25 empire Exp $";
#endif /* not lint */

/*
 * thre.c
 *
 * describe threshold for given commodity in a sector
 * just like deliver...except this is used for distribution
 * sectors.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "item.h"
#include "nsc.h"
#include "nat.h"
#include "file.h"

/*
 * threshold <COMM> <SECTS> <THRESH>
 */
thre()
{
	extern	struct ichrstr *whatitem();
	struct	sctstr sect;
	struct	nstr_sect nstr;
	int	val;
	struct	ichrstr *ip;
	s_char	*p;
	int	thresh;
	int	type;
	s_char	prompt[128];
	s_char	buf[128];

	if ((ip = whatitem(player->argp[1], "What commodity? ")) == 0)
		return RET_SYN;
	if (!snxtsct(&nstr, player->argp[2]))
		return RET_SYN;
	type = V_DIST(ip->i_vtype & ~VT_TYPE);
	if (player->argp[3] && *player->argp[3] &&
	    (*player->argp[3] < '0' || *player->argp[3] > '9')) {
		pr ("Threshold must be a number\n");
		return RET_SYN;
	}
	while (!player->aborted && nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		val = getvar(type, (s_char *)&sect, EF_SECTOR);
		if (val > 0)
			sprintf(prompt, "%s %s  old threshold %d new? ",
				xyas(nstr.x, nstr.y, player->cnum),
				dchr[sect.sct_type].d_name, val);
		else
			sprintf(prompt, "%s %s  threshold? ",
				xyas(nstr.x, nstr.y, player->cnum),
				dchr[sect.sct_type].d_name);
		if ((p = getstarg(player->argp[3], prompt, buf)) == 0)
			return RET_FAIL;
		if (*p == '\0' || *p == '-')
			continue;
		thresh = atoi(p);
		if (thresh > 10000)
			thresh = 10000;
		if (val > 0 && (player->argp[3] != 0 && *player->argp[3] != 0))
			pr("%s old threshold %d\n",
				xyas(nstr.x, nstr.y, player->cnum),
				val);
		if (putvar(type, thresh, (s_char *)&sect, EF_SECTOR) < 0)
			pr("No room for threshold in %s\n",
				xyas(nstr.x, nstr.y, player->cnum));
		putsect(&sect);
	}
	return RET_OK;
}
