#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/scut.c,v 2.5 1995/10/01 22:06:29 empire Exp $";
#endif /* not lint */

/*
 * scut.c
 *
 * Scuttle ships or planes
 * Taken from scra.c
 */

#include "misc.h"
#include "player.h"
#include "sect.h"
#include "news.h"
#include "var.h"
#include "xy.h"
#include "ship.h"
#include "land.h"
#include "plane.h"
#include "nat.h"
#include "nsc.h"
#include "deity.h"
#include "file.h"
#include "edb.h"

union item_u {
	struct shpstr ship;
	struct plnstr plane;
	struct lndstr land;
};

scut()
{
	struct	nstr_item ni;
	union	item_u item;
	int	type;
	struct	mchrstr *mp;
	struct	plchrstr *pp;
	struct	lchrstr *lp;
	s_char	*p;
	struct  nstr_item ni2;
	struct  plnstr plane;
	struct	sctstr sect2;
	s_char	prompt[128];
	s_char	buf[1024];

	if (!(p = getstarg(player->argp[1], "Ship, land, or plane? ", buf)))
		return RET_SYN;
	switch (*p) {
	case 's':
		type = EF_SHIP; break;
	case 'p':
		type = EF_PLANE; break;
	case 'l':
		type = EF_LAND; break;
	default:
		pr("Ships, land units, or planes only! (s, l, p)\n");
		return RET_SYN;
	}
	sprintf(prompt, "%s(s)? ", ef_nameof(type));
	if ((p = getstarg(player->argp[2], prompt, buf)) == 0)
		return RET_SYN;
	if (!snxtitem(&ni, type, p))
		return RET_SYN;
	if (p && (isalpha(*p) || (*p == '*') || (*p == '~') || issector(p)
		|| islist(p))){
		s_char y_or_n[80], bbuf[80];

		if (type == EF_SHIP) {
			if (*p == '*')
				sprintf(bbuf,"all ships");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned ships");
			else if (issector(p))
				sprintf(bbuf,"all ships in %s",p);
			else if (isalpha(*p))
				sprintf(bbuf,"fleet %c",*p);
			else
				sprintf(bbuf,"ships %s",p);
		} else if (type == EF_LAND) {
			if (*p == '*')
				sprintf(bbuf,"all land units");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned land units");
			else if (issector(p))
				sprintf(bbuf,"all units in %s",p);
			else if (isalpha(*p))
				sprintf(bbuf,"army %c",*p);
			else
				sprintf(bbuf,"units %s",p);
		} else {
			if (*p == '*')
				sprintf(bbuf,"all planes");
			else if (*p == '~')
				sprintf(bbuf,"all unassigned planes");
			else if (issector(p))
				sprintf(bbuf,"all planes in %s",p);
			else if (isalpha(*p))
				sprintf(bbuf,"wing %c",*p);
			else
				sprintf(bbuf,"planes %s",p);
		}
		sprintf(y_or_n,"Really scuttle %s? ", bbuf);
		if (!confirm(y_or_n))
			return RET_FAIL;
	}
	while (nxtitem(&ni, (s_char *)&item)) {
		if (!player->owner)
			continue;
		if (type == EF_SHIP) {			
			mp = &mchr[item.ship.shp_type];
#ifdef TRADESHIPS
			if (mp->m_flags & M_TRADE)
				if (!scuttle_tradeship(&item.ship))
					continue;
#endif /* TRADESHIPS */
			pr("%s", prship(&item.ship));
			getsect(item.ship.shp_x,item.ship.shp_y,&sect2);
			snxtitem_all(&ni2, EF_PLANE);
			while (nxtitem(&ni2, (s_char *)&plane)) {
				if (plane.pln_own == 0)
					continue;
				if (plane.pln_ship == item.ship.shp_uid){
					if (sect2.sct_own != player->cnum){
						wu(0,player->cnum,"Plane %d scuttled in %s\n",ni2.cur,xyas(plane.pln_x, plane.pln_y,player->cnum));
						plane.pln_own = 0;
					}
					else{
						wu(0,player->cnum,"Plane %d transferred off ship %d to %s\n",ni2.cur,item.ship.shp_uid,xyas(plane.pln_x, plane.pln_y,player->cnum));
						plane.pln_ship = -1;
					}
					putplane(plane.pln_uid, (s_char *)&plane);
				}
			}
			item.ship.shp_own = 0;
			putship(item.ship.shp_uid, (s_char *)&item.ship);
		}else
		if (type == EF_LAND) {
			if (item.land.lnd_ship >= 0){
				pr("%s is on a ship, and cannot be scuttled!\n", prland(&item.land));
				continue;
			}
			lp = &lchr[item.land.lnd_type];
			pr("%s", prland(&item.land));
			getsect(item.land.lnd_x,item.land.lnd_y,&sect2);
			snxtitem_all(&ni2, EF_PLANE);
			while (nxtitem(&ni2, (s_char *)&plane))
				if (plane.pln_land == item.land.lnd_uid){
					if (sect2.sct_own != player->cnum){
						wu(0,player->cnum,"Plane %d scuttled in %s\n",ni2.cur,xyas(plane.pln_x, plane.pln_y,player->cnum));
						plane.pln_own = 0;
					}
					else{
						wu(0,player->cnum,"Plane %d transferred off land unit %d to %s\n",ni2.cur,item.land.lnd_uid,xyas(plane.pln_x, plane.pln_y,player->cnum));
						plane.pln_land = -1;
					}
					putplane(plane.pln_uid, (s_char *)&plane);
				}
			item.land.lnd_own = 0;
			putland(item.land.lnd_uid, (s_char *)&item.land);
		} else {
			pp = &plchr[item.plane.pln_type];
			pr("%s", prplane(&item.plane));
			if (item.plane.pln_ship >= 0){
				struct shpstr ship;
				getship(item.plane.pln_ship,&ship);
				take_plane_off_ship(&item.plane,&ship);
			}
			item.plane.pln_own = 0;
			putplane(item.plane.pln_uid, (s_char *)&item.plane);
		}
		pr(" scuttled in %s\n", 
		   xyas(item.ship.shp_x, item.ship.shp_y , player->cnum));
	}

	return RET_OK;
}

#ifdef TRADESHIPS
static
scuttle_tradeship(sp)
	struct	shpstr	*sp;
{
	extern	int   trade_1_dist;	/* less than this gets no money */
	extern	int   trade_2_dist;	/* less than this gets trade_1 money */
	extern	int   trade_3_dist;	/* less than this gets trade_2 money */
	extern	float trade_1;		/* return on trade_1 distance */
	extern	float trade_2;		/* return on trade_2 distance */
	extern	float trade_3;		/* return on trade_3 distance */
	extern	float trade_ally_bonus;	/* 20% bonus for trading with allies */
	extern	float trade_ally_cut;	/* 10% bonus for ally you trade with */
	float	cash = 0;
	float	ally_cash = 0;
	int	dist;
	struct	sctstr sect;
	struct	mchrstr *mp;
	struct	natstr *np;
	s_char	buf[512];

	mp = &mchr[sp->shp_type];
	getsect(sp->shp_x,sp->shp_y,&sect);
	if (sect.sct_own && sect.sct_type == SCT_HARBR) {
		dist = mapdist(sp->shp_x, sp->shp_y,
			       sp->shp_orig_x,
			       sp->shp_orig_y);
		pr("%s has gone %d sects\n", prship(sp), dist);
		if (dist < trade_1_dist)
			cash = 0;
		else if (dist < trade_2_dist)
			cash = (1.0 + trade_1*((float)dist));
		else if (dist < trade_3_dist)
			cash = (1.0 + trade_2*((float)dist));
		else
			cash = (1.0 + trade_3*((float)dist));
		cash *= mp->m_cost;
		cash *= (((float)sp->shp_effic) / 100.0);

		if (sect.sct_own != sp->shp_own) {
			cash *= (1.0 + trade_ally_bonus);
			ally_cash = cash * trade_ally_cut;
		}
	}

	if (cash)
		player->dolcost -= cash;
	else {
		pr("You won't get any money if you scuttle in %s!",
			xyas(sp->shp_x, sp->shp_y, player->cnum));
		sprintf(buf, "Are you sure you want to scuttle %s? ",
			prship(sp));
		return confirm(buf);
	}

	if (ally_cash) {
		np = getnatp(sect.sct_own);
		np->nat_money += ally_cash;
		prsync(np->nat_cnum, np, EDV_ALL);
		putnat(np);
		wu(0,sect.sct_own,
		   "Trade with %s nets you $%d at %s\n",
		   cname(sp->shp_own),
		   (int)ally_cash,
		   xyas(sect.sct_x, sect.sct_y, sect.sct_own));
		if (sp->shp_own != sp->shp_orig_own)
			nreport(sp->shp_own,
				N_PIRATE_TRADE, sp->shp_orig_own, 1);
		else
			nreport(sp->shp_own, N_TRADE, sect.sct_own, 1);
	} else if (sp->shp_own != sp->shp_orig_own)
		nreport(sp->shp_own, N_PIRATE_KEEP, sp->shp_orig_own, 1);

	return 1;
}
#endif /* TRADESHIPS */
