#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/nuke.c,v 2.1 1995/10/01 21:55:12 empire Exp $";
#endif /* not lint */

/*
 * nuke.c
 *
 * combines fail, deto, and nuke report
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "nuke.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "file.h"

int
nuke()
{
	register int first_line = 0;
	register int first_nuke;
	register int show_comm;
	register int i;
	struct	nstr_item nstr;
	struct	nukstr nuk;
	struct	sctstr sect;
	int	item[I_MAX+1];

	if (!snxtitem(&nstr, EF_NUKE, player->argp[1]))
		return RET_SYN;

	while (nxtitem(&nstr, (s_char *)&nuk)) {
		if (!player->god && !player->owner)
			continue;
		if (nuk.nuk_own == 0)
			continue;
		if (first_line++ == 0) {
			if (player->god)
				pr("own ");
			pr("  sect        eff num nuke-type         lcm   hcm   oil   rad avail\n");
		}
		getsect(nuk.nuk_x, nuk.nuk_y, &sect);
		getvec(VT_ITEM, item, (s_char *)&sect, EF_SECTOR);
		first_nuke = 1;
		show_comm = 0;
		if (sect.sct_type == SCT_NUKE && sect.sct_effic >= 60)
			show_comm = 1;
		for (i = 0; i < N_MAXNUKE; i++) {
			if (nuk.nuk_types[i] > 0) {
				if (first_nuke) {
					if (player->god)
						pr("%-3d ", nuk.nuk_own);
					prxy("%4d,%-4d", sect.sct_x, sect.sct_y, player->cnum);
					pr(" %c", dchr[sect.sct_type].d_mnem);
					if (sect.sct_newtype != sect.sct_type)
						pr("%c", dchr[sect.sct_newtype].d_mnem);
					else
						pr(" ");
					pr("%4d%%", sect.sct_effic);
					first_nuke = 0;
				} else {
					pr("                 ");
				}

				pr("%3d ", nuk.nuk_types[i]);
				pr("%-16.16s ", nchr[i].n_name);
				
				if (show_comm) {
					pr("%5d ", item[I_LCM]);
					pr("%5d ", item[I_HCM]);
					pr("%5d ", item[I_OIL]);
					pr("%5d ", item[I_RAD]);
					pr("%5d", sect.sct_avail);
					show_comm = 0;
				}
				pr("\n");
			}
		}
	}
	return RET_OK;
}
