#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/name.c,v 2.1 1995/10/11 03:02:33 empire Exp $";
#endif /* not lint */

/*
 * name.c
 *
 * name a ship
 *
 * Jeff Bailey (bailey@mcs.kent.edu)
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "ship.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "file.h"
#include "path.h"

#ifdef	SHIPNAMES

/*
 * name <SHIP> <NAME>
 */
name()
{
	struct	shpstr	ship;
	s_char	*p;
	struct nstr_item nb;
	s_char	buf[1024];

	if (!snxtitem(&nb, EF_SHIP, player->argp[1]))
		return RET_SYN;
	while (nxtitem(&nb, (s_char *)&ship)) {
		if (!player->owner)
			continue;
		p = getstarg(player->argp[2], "Name? ", buf);
		if (p == 0 || *p == 0)
			return RET_SYN;
		if (!strcmp(p,"~")) {
			ship.shp_name[0] = 0;
		}
		else
		{
			strncpy(ship.shp_name,p,MAXSHPNAMLEN - 1);
			ship.shp_name[MAXSHPNAMLEN - 1] = 0;
		}
		putship(ship.shp_uid,&ship);
	}

	return RET_OK;
}

#endif	/* SHIPNAMES */
