#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/flee.c,v 2.0 1995/01/25 19:23:25 empire Exp $";
#endif /* not lint */

/*
 * flee.c
 *
 * add ships to fleet
 *
 * from PSL Empire, 1985
 * XXX should merge with wing.c.
 */

#include <ctype.h>
#include "misc.h"
#include "player.h"
#include "var.h"
#include "ship.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"
#include "nat.h"

flee()
{
	struct shpstr ship;
	register int count;
	s_char	*cp;
	s_char	c;
	struct	nstr_item nstr;
	struct  nstr_item ni;
	struct	shpstr ship2;
	int	r;
	s_char	buf[1024];

	cp = getstarg(player->argp[1], "fleet? ", buf);
	if (cp == 0)
		return RET_SYN;
	c = *cp;
	if (!isalpha(c) && c != '~') {
		pr("Specify fleet, (1 alpha char or '~')\n");
		return RET_SYN;
	}
	if (c == '~')
		c = ' ';
	if (!snxtitem(&nstr, EF_SHIP, player->argp[2]))
		return RET_SYN;
	count = 0;
	while (nxtitem(&nstr, (s_char *)&ship)) {
		if (!player->owner)
			continue;
		ship.shp_fleet = c;
		snxtitem(&ni, EF_SHIP, cp);
		while((r=nxtitem(&ni, (s_char *)&ship2))
			&& (ship2.shp_fleet != c));
		if (r){
			bcopy(ship2.shp_rpath, ship.shp_rpath,10);
			ship.shp_rflags = ship2.shp_rflags;
		}
		putship(nstr.cur, &ship);
		count++;
	}
	pr("%d ship%s added to fleet `%c'\n", count, splur(count), c);
	return RET_OK;
}
