#include <stdio.h>
#include "as.h"
#include "misc.h"

#if !defined(lint) && !defined(SABER)
static	char	sccsid[] = "@(#)as_init.c	1.4	11/13/90";
#endif /* not lint */

extern	s_char *calloc();

/*
 * Return an as_data structure with the necessary fields filled in
 * and space malloced.  Return NULL if malloc fails.
 */
struct as_data *
as_init(maxneighbors, hashsize, hashfunc, neighborfunc,
	lbcostfunc, realcostfunc, seccostfunc, userdata)
	int	maxneighbors;
	int	(*hashfunc)();
	int	(*neighborfunc)();
	double	(*lbcostfunc)();
	double	(*realcostfunc)();
	double	(*seccostfunc)();
	s_char	*userdata;
{
	struct as_data	*adp;

	AS_NEW(adp, struct as_data, NULL);
	AS_NEW_ARRAY(adp->neighbor_coords, struct as_coord,
		maxneighbors, NULL);
	AS_NEW_ARRAY(adp->neighbor_nodes, struct as_node *,
		maxneighbors + 1, NULL);
	AS_NEW_ARRAY(adp->hashtab, struct as_hash *,
		hashsize, NULL);

	adp->maxneighbors = maxneighbors;
	adp->hashsize = hashsize;
	adp->hash = hashfunc;
	adp->neighbor = neighborfunc;
	adp->lbcost = lbcostfunc;
	adp->realcost = realcostfunc;
	adp->seccost = seccostfunc;
	adp->userdata = userdata;

	return (adp);
}
