#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/subs/list.c,v 2.6 1995/10/16 20:35:05 empire Exp $";
#endif

/*
 * list.c
 *
 * list ships, planes at a given x,y.
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "news.h"
#include "ship.h"
#include "land.h"
#include "sect.h"
#include "nuke.h"
#include "plane.h"
#include "nat.h"
#include "item.h"
#include "xy.h"
#include "nsc.h"
#include "file.h"

extern	s_char *effadv();

int
shipsatxy(x, y, wantflags, nowantflags)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
{
	int	first;
	int	ships;
	struct	nstr_item ni;
	struct	mchrstr *mp;
	struct	shpstr ship;

	first = 1;
	ships = 0;
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (player->owner)
			continue;
		if (ship.shp_effic < SHIP_MINEFF || ship.shp_own == 0)
			continue;
		mp = &mchr[ship.shp_type];
		if (wantflags) {
			if ((mp->m_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (mp->m_flags & nowantflags)
				continue;
		}
		if (first) {
			pr(" #          owner           eff       type\n");
			first = 0;
		}
		pr("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
		   cname(ship.shp_own),
		   effadv(ship.shp_effic), prship(&ship));
		ships++;
	}
	return ships;
}

/* This one only shows owned or allied ships */

int
carriersatxy(x, y, wantflags, nowantflags, own)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
	natid	own;
{
	int	first;
	int	ships;
	struct	nstr_item ni;
	struct	mchrstr *mp;
	struct	shpstr ship;
	int	allied;

	first = 1;
	ships = 0;
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (ship.shp_effic < SHIP_MINEFF || ship.shp_own == 0)
			continue;
		allied = (getrel(getnatp(ship.shp_own), own) == ALLIED);
		if ((ship.shp_own != own) & !allied)
			continue;
		mp = &mchr[ship.shp_type];
		if (wantflags) {
			if ((mp->m_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (mp->m_flags & nowantflags)
				continue;
		}
		if (first) {
			pr(" #          owner           eff       type\n");
			first = 0;
		}
		pr("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
		   cname(ship.shp_own),
		   effadv(ship.shp_effic),
		   prship(&ship));
		ships++;
	}
	return ships;
}

int
unitsatxy(x, y, wantflags, nowantflags)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
{
	int	first;
	int	units;
	struct	nstr_item ni;
	struct	lchrstr *lp;
	struct	lndstr land;

	first = 1;
	units = 0;
	snxtitem_xy(&ni, EF_LAND, x, y);
	while (nxtitem(&ni, (s_char *)&land)) {
		if (land.lnd_effic < 20 || land.lnd_own == 0)
			continue;
		lp = &lchr[land.lnd_type];
		if (wantflags) {
			if ((lp->l_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (lp->l_flags & nowantflags)
				continue;
		}
		if (first) {
			pr(" #          owner           eff       type\n");
			first = 0;
		}
		pr("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
			cname(land.lnd_own),
			effadv(land.lnd_effic), prland(&land));
		units++;
	}
	return units;
}

int
planesatxy(x, y, wantflags, nowantflags)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
{
	int	first;
	int	planes;
	struct	plnstr plane;
	struct	nstr_item ni;
	struct	plchrstr *plp;

	planes = 0;
	first = 1;
	snxtitem_xy(&ni, EF_PLANE, x, y);
	while (nxtitem(&ni, (s_char *)&plane)) {
		if (plane.pln_effic < PLANE_MINEFF || plane.pln_own == 0)
			continue;
		if (plane.pln_flags & PLN_LAUNCHED)
			continue;
		plp = &plchr[plane.pln_type];
		if (first) {
			pr(" #          owner           eff       type\n");
			first = 0;
		}
		if (wantflags) {
			if ((plp->pl_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (plp->pl_flags & nowantflags)
				continue;
		}
		pr("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
			cname(plane.pln_own),
			effadv(plane.pln_effic), prplane(&plane));
		planes++;
	}
	return planes;
}

int
asw_shipsatxy(x, y, wantflags, nowantflags, pp, head)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
	struct	plnstr *pp;
	struct	shiplook *head;
{
	int	first;
	int	ships;
	struct	nstr_item ni;
	struct	mchrstr *mp;
	struct	shpstr ship;
	double	detect;

	first = 1;
	ships = 0;
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (player->owner)
			continue;
		if (ship.shp_effic < SHIP_MINEFF || ship.shp_own == 0)
			continue;
		mp = &mchr[ship.shp_type];
		if (wantflags) {
			if ((mp->m_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (mp->m_flags & nowantflags)
				continue;
		}
		if (mp->m_flags & M_SUB){
			if (roll(100) > pln_hitchance(pp,
						      shp_hardtarget(&ship),
						      EF_SHIP))
				continue;
		}
		set_have_found(ship.shp_uid,head);
		if (first) {
			pr(" #          owner           eff       type\n");
			first = 0;
		}
		pr("(#%3d) %10.10s  %12.12s  %s\n", ni.cur,
		   cname(ship.shp_own),
		   effadv(ship.shp_effic), prship(&ship));
		ships++;
	}
	return ships;
}

int
num_shipsatxy(x, y, wantflags, nowantflags)
	coord	x;
	coord	y;
	int	wantflags;
	int	nowantflags;
{
	int	ships;
	struct	nstr_item ni;
	struct	mchrstr *mp;
	struct	shpstr ship;

	ships = 0;
	snxtitem_xy(&ni, EF_SHIP, x, y);
	while (nxtitem(&ni, (s_char *)&ship)) {
		if (ship.shp_effic < SHIP_MINEFF || ship.shp_own == 0)
			continue;
		mp = &mchr[ship.shp_type];
		if (wantflags) {
			if ((mp->m_flags & wantflags) == 0)
				continue;
		}
		if (nowantflags) {
			if (mp->m_flags & nowantflags)
				continue;
		}
		ships++;
	}
	return ships;
}

/*
 * is p a list of ships/planes/units?
 *
 */

islist(p)
s_char *p;
{
	register int x;

	x=0;

	while(*(p+x)){
		if (!isdigit(*(p+x)) && (*(p+x) != '/'))
			return 0;

		x++;
	}

	return 1;
}
