#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/mult.c,v 2.1 1995/10/11 03:02:33 empire Exp $";
#endif /* not lint */

/*
 * mult.c
 *
 * Set per-nation list of price multipliers.  This should go in the
 * nation structure I think...
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "nat.h"
#include "file.h"
#include "xy.h"
#include "nsc.h"
#include <math.h>		/* bailey@math-cs.kent.edu */

static void	multsingle();

mult()
{
	struct	nstr_item ni;
	struct	natstr nat;
	int	nats;

	if (!snxtitem(&ni, EF_NATION, player->argp[1]))
		return RET_SYN;
	if (commread() < 0) {
		pr("Unable to read commodity file; get help!\n");
		return RET_SYS;
	}
	nats = 0;
	while (!player->aborted && nxtitem(&ni, (s_char *)&nat)) {
		if ((nat.nat_stat & STAT_NORM) == 0)
			continue;
		multsingle(player->cnum, (natid)ni.cur, &nat);
		nats++;
	}
	pr("%d nation multipliers changed\n", nats);
	return RET_OK;
}

/*
 * Set the multipler for a single country.
 */
static void
multsingle(us, them, natp)
	natid	us;
	natid	them;
	struct	natstr *natp;
{
	extern	double minmult;
	extern	double maxmult;
	double	price;
	s_char	*p;
	s_char	prompt[128];
	s_char	buf[1024];

	sprintf(prompt, "%s (%7.3f) : ", natp->nat_cnam, multread(us, them));
	p = getstarg(player->argp[2], prompt, buf);
	if (p == 0 || *p == 0)
		return;
	if ((price = atof(p)) == 0.0)
		return;
	if ((price == HUGE) || (price > 1000000.0)) /* Inf causes overflow. */
		price = 1000000.0;		/* bailey@math-cs.kent.edu */
	/*
	 * no free lunches!
	 */
	if (price <= minmult)
		price = minmult;
	if (price >= maxmult)
		price = maxmult;
	if (!commlock()) {
		pr("Unable to lock commodity file; get help!\n");
		return;
	}
	if (commread() < 0) {
		(void) communlock();
		pr("Unable to re-read commodity file; get help!\n");
		return;
	}
	multset(them, price);
	if (commwrite() < 0) {
		pr("Unable to write out commodity file; get help!\n");
	}
	(void) communlock();
}
