#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/cuto.c,v 2.1 1995/08/21 21:19:15 empire Exp $";
#endif /* not lint */

/*
 * cuto.c
 *
 * do a delivery cutoff level report
 *
 * David Muir Sharnoff, 1987
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "sect.h"
#include "xy.h"
#include "nsc.h"
#include "nat.h"
#include "path.h"
#include "deity.h"
#include "file.h"

cuto()
{
	struct	sctstr sect;
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	s_char	dirstr[12];
	int	del[I_MAX+1];

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	prdate();
	(void) strcpy(dirstr, ".      $");
	n = 1;
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		if (nsect++ == 0) {
			pr("DELIVERY CUTOFF LEVELS\n");
			if (player->god) 
				pr("own");
			pr("     sect   ufsgpidbolhr   uw food  sh gun pet iron dust bar oil lcm hcm rad\n");
		}
		if (player->god)
			pr("%3d ", sect.sct_own);
		getvec(VT_DEL, del, (s_char *)&sect, EF_SECTOR);
		pr("%9s", xyas(nstr.x, nstr.y, player->cnum));
		pr(" %c ", dchr[sect.sct_type].d_mnem);
		pr("%c", dirstr[del[I_UW] & 0x7]);
		pr("%c", dirstr[del[I_FOOD] & 0x7]);
		pr("%c", dirstr[del[I_SHELL] & 0x7]);
		pr("%c", dirstr[del[I_GUN] & 0x7]);
		pr("%c", dirstr[del[I_PETROL] & 0x7]);
		pr("%c", dirstr[del[I_IRON] & 0x7]);
		pr("%c", dirstr[del[I_DUST] & 0x7]);
		pr("%c", dirstr[del[I_BAR] & 0x7]);
		pr("%c", dirstr[del[I_OIL] & 0x7]);
		pr("%c", dirstr[del[I_LCM] & 0x7]);
		pr("%c", dirstr[del[I_HCM] & 0x7]);
		pr("%c ", dirstr[del[I_RAD] & 0x7]);
		pr("%4d", del[I_UW] & ~0x7);
		pr("%5d", del[I_FOOD] & ~0x7);
		pr("%4d", del[I_SHELL] & ~0x7);
		pr("%4d", del[I_GUN] & ~0x7);
		pr("%4d", del[I_PETROL] & ~0x7);
		pr("%5d", del[I_IRON] & ~0x7);
		pr("%5d", del[I_DUST] & ~0x7);
		pr("%4d", del[I_BAR] & ~0x7);
		pr("%4d", del[I_OIL] & ~0x7);
		pr("%4d", del[I_LCM] & ~0x7);
		pr("%4d", del[I_HCM] & ~0x7);
		pr("%4d", del[I_RAD] & ~0x7);
		pr("\n");
	}
	if (nsect == 0) {
		if (player->argp[1])
			pr("%s: No sector(s)\n", player->argp[1]);
		else
			pr("%s: No sector(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d sector%s\n", nsect, splur(nsect));
	return RET_OK;
}
