#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/common/nat.c,v 2.2 1995/07/29 21:57:56 empire Exp $";
#endif

/*
 * nat.c
 *
 * misc accesses on the nation file,
 * just associated with the in-memory copy.
 *
 * Dave Pare, 1989
 */

#include "misc.h"
#include "nat.h"
#include "file.h"

s_char *
cname(n)
	natid	n;
{
	struct	natstr *np;

	if ((np = getnatp(n)) == 0)
		return 0;
	return np->nat_cnam;
}

s_char *
relatename(np, other)
	struct	natstr *np;
	natid	other;
{
	extern	s_char *relates[];

	return relates[getrel(np, other)];
}

s_char *
rejectname(np, other)
	struct	natstr *np;
	natid	other;
{
	extern s_char	*rejects[];

	return rejects[getrejects(other, np)];
}

s_char *
natstate(np)
	struct	natstr *np;
{
	if ((np->nat_stat & STAT_INUSE) == 0)
		return "FREE";
	if (np->nat_stat & STAT_GOD)
		return "DEITY";
	if ((np->nat_stat & STAT_NORM) == 0)
		return "VISITOR";
	return "ACTIVE";
}

int
getrel(np, them)
	struct	natstr *np;
	natid	them;
{
	return np->nat_relate[them];
}

int
getrejects(them, np)
	natid	them;
	struct	natstr *np;
{
	int	ind;
	int	shift;
	int	reject;

	ind = them / 4;
	shift = 12 - ((them - ((them / 4) << 2)) * 4);
	/* the 07 should *really* be 017 */
	reject = (np->nat_rejects[ind] >> shift) & 0x0f;
	return reject;
}

#ifdef HIDDEN
int
getcontact(np, them)
	struct 	natstr *np;
	natid  	them;
{
	int	contact;

#ifdef LOSE_CONTACT
	contact = np->nat_contact[them];
#else
	int ind = them/16;
	int shift = (them % 16);
	contact = (np->nat_contact[ind] >> shift) & 1;
#endif /* LOSE_CONTACT */
	return contact;
}	
#endif /* HIDDEN */
	
putrel(np, them, relate)
	struct	natstr *np;
	natid	them;
	int	relate;
{
	np->nat_relate[them] = relate;
}

putreject(np, them, how, what)
	struct	natstr *np;
	natid	them;
	int	how;
	int	what;
{
	int	shift;
	int	newrej;
	int	ind;

	/* This 07 should be changed to 017 after the current game is over */
	what &= 0x0f;
	ind = them / 4;
	shift = 12 - ((them - ((them / 4) << 2)) * 4);
	newrej = np->nat_rejects[ind];
	if (how)
		newrej |= (what << shift);
	else
		newrej &= ~(what << shift);
	np->nat_rejects[ind] = newrej;
}

#ifdef HIDDEN
putcontact(np, them, contact)
	struct	natstr *np;
	natid	them;
	int	contact;
{
#ifdef LOSE_CONTACT
	if (np->nat_contact[them] > contact)
		return 0;
	np->nat_contact[them] = contact;
#else
	int ind = them/16;
	int shift = them%16;
	int new = np->nat_contact[ind];
	if (contact)
		contact = 1;
	new &= ~(1 << shift);
	new |= (contact << shift);
	np->nat_contact[ind] = new;
#endif /* LOSE_CONTACT */
}
#endif /* HIDDEN */
