#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/common/hours.c,v 2.2 1995/10/11 02:56:04 empire Exp $";
#endif /* not lint */

/*
 * hours.c
 *
 * Game hours determination; is it legal to play now?
 *
 * Dave Pare, 1989
 */

#include <stdio.h>
#include "misc.h"
#include "nat.h"
#include "tel.h"
#include "proto.h"
#include "com.h"
#include "deity.h"
#include "keyword.h"
#include "file.h"

#ifdef Rel4
#include <time.h>
#else
#include <sys/time.h>
#endif /* Rel4 */

/*
 * returns true if game can be played now.
 * Sets the number of minutes until the hours
 * function must be re-called.
 */
int
gamehours(now, hour)
	time_t	now;
	int	*hour;
{
	extern	s_char *hoursfil;
	extern	s_char *kw_find();
	extern	int errno;
	extern	struct tm *localtime();
	register s_char *bp;
	register struct tm *tm;
	FILE	*fp;
	int	day;
	int	curtime;
	int	okday[7];
	int	tomorrow;

	tm = localtime(&now);
	if ((fp = fopen(hoursfil, "r")) == 0) {
		errno = 0;
		return 1;
	}
	kw_read(fp);
	fclose(fp);
	curtime = tm->tm_min + tm->tm_hour * 60;
	if (bp = kw_find("days")) {
		for (day=0; day<7; day++)
			okday[day] = 0;
		while (bp = kw_parse(CF_WEEKDAY, bp, &day))
			okday[day] = 1;
	} else {
		for (day=0; day<7; day++)
			okday[day] = 1;
	}
	if (!okday[tm->tm_wday])
		return 0;
	if (bp = kw_find("hours")) {
		while (bp = kw_parse(CF_TIMERANGE, bp, hour))
			if (curtime >= hour[0] && curtime < hour[1])
				break;
		if (bp == 0)
			return 0;
	} else {
		hour[0] = 0;
		hour[1] = 24*60;
	}
	tomorrow = tm->tm_wday + 1;
	if (tomorrow >= 7)
		tomorrow = 0;
	return 1;
}
