#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/vers.c,v 2.8 1995/10/11 02:49:09 empire Exp $";
#endif /* not lint */

/*
 * vers.c
 *
 * empire version (probably out of date by now!)
 *
 * from PSL Empire, 1985
 */

#include <stdio.h>
#include <time.h>
#include "gamesdef.h"
#include "misc.h"
#include "player.h"
#include "deity.h"
#include "nat.h"
#include "version.h"
#include "ship.h" 
#include "optlist.h"

extern float drnuke_const;

vers()
{
	extern	int s_p_etu;
	extern	int etu_per_update;
	extern	int adj_update;
	extern	int m_m_p_d;
	extern	int players_at_00;
	extern	float btu_build_rate;
	extern	double fgrate, fcrate;
	extern	double eatrate, babyeat;
	extern	double obrate, uwbrate;
	extern	double bankint;
	extern	double hap_cons, edu_cons;
	extern	double money_civ, money_uw, money_mil, money_res;
	extern	float hap_avg, edu_avg, ally_factor;
	extern	float level_age_rate;
/*	extern	float easy_tech, hard_tech, tech_log_base; */
	extern	float easy_tech, tech_log_base;
	extern	int land_mob_max;
	extern	int land_grow_scale;
	extern	float land_mob_scale;
	extern	int sect_mob_max;
	extern	float sect_mob_scale;
	extern	int ship_mob_max;
	extern	float ship_mob_scale;
	extern	int ship_grow_scale;
	extern	int plane_mob_max;
	extern	float plane_mob_scale;
	extern	int plane_grow_scale;
	extern  War_Cost;
	struct option_list *op;

	time_t	now;
	int	j;

	(void) time(&now);
	pr("Empire %d.%d.%d\n(KSU distribution %2.2f, Chainsaw version %2.2f)\n\n",
		EMP_VERS_MAJOR, EMP_VERS_MINOR, EMP_VERS_PATCH,
		(float)KSU_DIST, (float)CHAINSAW_DIST);
	pr("The following parameters have been set for this game:\n");
	pr("World size is %d by %d.\n", WORLD_X, WORLD_Y);
	pr("There can be up to %d countries.\n", MAXNOC);
	pr("By default, countries use %s coordinate system.\n",
		(players_at_00) ? "the deity's" : "their own");
	pr("\n");
	pr("An Empire time unit is %d second%s long.\n",
		s_p_etu, s_p_etu != 1 ? "s" : "");
	pr("Use the 'update' command to find out the time of the next update.\n");
	pr("The current time is %19.19s.\n",ctime(&now));
	pr("An update consists of %d empire time units.\n",
		etu_per_update);
	pr("Each country is allowed to be logged in %d minutes a day.\n",
		m_m_p_d);
	pr("It takes %.2f civilians to produce a BTU in one time unit.\n",
		(1.0/(btu_build_rate*100.0)));
	pr("\n");

	pr("A non-aggi, 100 fertility sector can grow %.2f food per etu.\n",
		100.0 * fgrate);
	pr("1000 civilians will harvest %.1f food per etu.\n",
			1000.0*fcrate);
	pr("1000 civilians will give birth to %.1f babies per etu.\n", 
			1000.0*obrate);
	pr("1000 uncompensated workers will give birth to %.1f babies.\n", 
			1000.0*uwbrate);
	if (opt_NOFOOD)
		pr("No food is needed!!\n");
	else
		pr("In one time unit, 1000 people eat %.1f units of food.\n", 
		   1000.0*eatrate);

	pr("1000 babies eat %.1f units of food becoming adults.\n", 
			1000.0*babyeat);
	pr("\n");

	pr("Banks pay $%.2f in interest per 1000 gold bars per etu.\n",
		bankint*1000.0);
	pr("1000 civilians generate $%.2f, uncompensated workers $%.2f each time unit.\n", 1000.0*money_civ, 1000.0*money_uw);
	pr("1000 active military cost $%.2f, reserves cost $%.2f.\n",
		-money_mil*1000.0, -money_res*1000.0);
	if (opt_SLOW_WAR)
		pr("Declaring war will cost you $%i\n\n", War_Cost);
	pr("Happiness p.e. requires 1 happy stroller per %d civ.\n",
		(int) hap_cons);
	pr("Education p.e. requires 1 class of graduates per %d civ.\n",
		(int) edu_cons);
	pr("Happiness is averaged over %d time units.\n", (int)hap_avg);
	pr("Education is averaged over %d time units.\n", (int)edu_avg);
	if (opt_ALL_BLEED == 0)
		pr(
	"The technology/research boost you get from your allies is %.2f%%.\n",
		   100.0/ally_factor);
	else	/* ! ALL_BLEED */
		pr(
	"The technology/research boost you get from the world is %.2f%%.\n",
		100.0/ally_factor);

	pr("Nation levels (tech etc.) decline 1%% every %d time units.\n",
		(int)(level_age_rate));

	pr("Tech Buildup is ");
/*	if (tech_log_base <= 1.0 && hard_tech == 0.0) { */
	if (tech_log_base <= 1.0 ) {
		pr("not limited\n");
	} 
	if (tech_log_base > 1.0) {
		pr("limited to logarithmic growth (base %.2f)",
			tech_log_base);
		if (easy_tech == 0.0) 
			pr(".\n");
		else
			pr(" after %0.2f.\n", easy_tech);
	} /*else {
		pr("limited to asymptotic growth towards %.2f",
			hard_tech + easy_tech);
		if (easy_tech == 0.00) 
			pr(".\n");
		else
			pr("after %.2f\n",easy_tech);
	} */

	pr("\n");
	pr("\t\t\t\tSectors\tShips\tPlanes\tUnits\n");
	pr("Maximum mobility\t\t%d\t%d\t%d\t%d\n", sect_mob_max,
		ship_mob_max, plane_mob_max, land_mob_max);
	pr("Max mob gain per update\t\t%d\t%d\t%d\t%d\n",
		(int)(sect_mob_scale*(float)etu_per_update), 
		(int)(ship_mob_scale*(float)etu_per_update), 
		(int)(plane_mob_scale*(float)etu_per_update),
		(int)(land_mob_scale*(float)etu_per_update));
	pr("Max eff gain per update\t\t--\t%d\t%d\t%d\n",
		min(ship_grow_scale*etu_per_update,100),
		min(plane_grow_scale*etu_per_update,100),
		min(land_grow_scale*etu_per_update,100));
	pr("\n");
        pr("Ships on autonavigation may use %i cargo holds per ship.\n\n",TMAX
               );
	if (opt_NONUKES)
		pr("Nukes are disabled.\n");
	else if(opt_DRNUKE) { /* NUKES && DRNUKE enabled */
		pr("In order to build a nuke, you need %1.2f times the tech level in research\n",
		   drnuke_const);
		pr("\tExample: In order to build a 300 tech nuke, you need %d research\n\n",
		   (int)(300.0*drnuke_const));
	}


	pr("\nOptions enabled in this game:\n        ");
	for (j = 0, op = Options; op -> opt_key; op++) {
		if (*op -> opt_valuep == 0)
			continue;

		j += strlen (op -> opt_key) + 2;
		if (j > 70) {
			pr ("\n        ");
			j = strlen (op -> opt_key) + 2;
		}
		pr ("%s%s", op -> opt_key, op[1].opt_key == NULL ? "":  ", ");
	}
	pr("\n\n");
	pr("The person to annoy if something goes wrong is:\n\t%s\n\t(%s).\n",
		privname, privlog);
#ifndef aix
	pr("You can get your own copy of the source %s\n", GET_SOURCE);
#endif /* aix */
	return RET_OK;
}
