/*
 * ship.h
 *
 * things having to do with ships
 *
 * from PSL Empire, 1985
 * $Revision: 2.7 $ $Date: 1995/10/11 03:11:17 $
 */

#ifndef _SHIP_H_
#define _SHIP_H_

#include "queue.h"

#define	SHIP_MINEFF	20

/* bit masks for the autonav mode flags */

#define AN_SAILDIR  1
#define AN_AUTONAV  2
#define AN_STANDBY  4
#define AN_LOADING  8

/* TMAX is the number of cargo holds a ship use in the autonav code. */
#define TMAX 6


#define MAXSHPV	12

#ifdef	SAIL
#define MAXSHPPATH	28
#endif	/* SAIL */
#ifdef	SHIPNAMES
#define	MAXSHPNAMLEN	24
#endif	/* SHIPNAMES */

#ifndef RET_LEN
#define RET_LEN 10
#endif /* RET_LEN */

struct	shpstr {
	short	ef_type;
	natid	shp_own;	/* owner's country num */
	short	shp_uid;	/* unit id (ship #) */
	coord	shp_x;		/* x location in abs coords */
	coord	shp_y;		/* y location in abs coords */
	s_char	shp_type;	/* ship type */
	s_char	shp_effic;	/* 0% to 100% */
	s_char	shp_mobil;	/* mobility units */
	short	shp_sell;	/* pointer to trade file */
	short	shp_tech;	/* tech level ship was built at */
	s_char	shp_fleet;	/* group membership */
	coord	shp_opx,shp_opy;/* Op sector coords */
	short	shp_mission;	/* mission code */
	short	shp_radius;	/* mission radius */
	u_char	shp_nplane;	/* number of planes on board */
	u_char	shp_nland;	/* number of land units on board */
	coord	shp_destx[2];	/* location for ship destination */
	coord	shp_desty[2];
	s_char  shp_tstart[TMAX]; /* what goods to pick up at start point */
	s_char  shp_tend[TMAX]; /* what goods to pick up at end point   */
	short   shp_lstart[TMAX]; /* How much do we pick up at the start  */
        short   shp_lend[TMAX];   /* How much do we pick up at the end    */
	u_char	shp_autonav;	/* autonavigation flags */
	s_char	shp_nv;		/* current number of variables */
	u_char	shp_vtype[MAXSHPV];
	u_short	shp_vamt[MAXSHPV];
#ifdef	SAIL
	u_char	shp_mobquota;	/* mobility quota */
	s_char	shp_path[MAXSHPPATH];
	short	shp_follow;
#endif	/* SAIL */
#ifdef	SHIPNAMES
	s_char	shp_name[MAXSHPNAMLEN];	/* name set with the "name" command */
#endif	/* SHIPNAMES */
	u_char	shp_fuel;	/* How much fuel do we have */
	u_char	shp_nchoppers;	/* How many choppers on board? */
	u_char	shp_nxlight;	/* How many xlight planes on board? */
#ifdef TRADESHIPS
	coord	shp_orig_x;
	coord	shp_orig_y;	/* Where we were built */
	natid	shp_orig_own;	/* Who built us */
#endif /* TRADESHIPS */
	int	shp_rflags;	/* When do I retreat? */
	s_char	shp_rpath[RET_LEN];	/* retreat path */
#ifndef SMALL_SERVER
        s_char  shp_sparec;     /* not used */
        int     shp_sparei;     /* not used */
        long    shp_sparel;     /* not used */
#endif /* SMALL_SERVER */
};

#ifdef	SAIL
struct fltelemstr {
  int	num;
  int	own;
  double	mobil,mobcost;
  struct fltelemstr	*next;
};

struct fltheadstr {
  int		leader;
  s_char	real_q;
/* defines for the real_q member */
#define	LEADER_VIRTUAL	0
#define	LEADER_REAL	1
#define	LEADER_WRONGSECT	2
  coord		x,y;
  natid		own;
  unsigned	maxmoves;
  struct fltelemstr	*head;
  struct fltheadstr	*next;
};
#endif	/* SAIL */

struct	mchrstr {
	u_char	m_nv;		/* number of variables it can hold */
	u_char	m_vtype[MAXCHRNV];
	u_short	m_vamt[MAXCHRNV];
	int	m_lcm;		/* units of lcm to build */
	int	m_hcm;		/* units of hcm to build */
	int	m_armor;	/* how well armored it is */
	int	m_speed;	/* how fast it can go */
	int	m_visib;	/* how well it can be seen */
	int	m_vrnge;	/* how well it can see */
	int	m_frnge;	/* how far it can fire */
	int	m_glim;		/* how many guns it can fire */
	u_char	m_nxlight;	/* maximum number of xlight planes */
	u_char	m_nchoppers;	/* maximum number of choppers */
	u_char	m_fuelc;	/* fuel capacity */
	u_char	m_fuelu;	/* fuel used per 10 mob */
	s_char	*m_name;	/* full name of type of ship */
	int	m_tech;		/* tech required to build */
	int	m_cost;		/* how much it costs to build */
	long	m_flags;	/* what special things can this ship do */
	u_char	m_nplanes;	/* maximum number of planes this ship holds */
	u_char	m_nland;	/* maximum number of units this ship holds */
};

#define M_FOOD		bit(0)	/* catch that fish! */
#define M_TORP		bit(1)	/* fire torpedoes */
#define M_DCH		bit(2)	/* drop depth charges on subs */
#define M_FLY		bit(3)	/* launch and recover planes */
/* M_MSL will be automatically set in init_global() if m_nplanes > 0
   and M_FLY is not set */
#define M_MSL		bit(4)	/* launch missiles */
#define M_OIL		bit(5)	/* drill for oil */
#define M_SONAR		bit(6)	/* locate submarines */
#define M_MINE		bit(7)	/* drop mines */
#define M_SWEEP		bit(8)	/* clean up the mines */
#define M_SUB		bit(9)	/* a submarine */
#define M_SPY		bit(10)	/* gather intelligence info */
#define M_LAND		bit(11)	/* allows full landing ability */
#define M_SUBT		bit(12)	/* allows torping of other subs */
#ifdef TRADESHIPS
#define M_TRADE		bit(13) /* is a trade ship */
#endif /* TRADESHIPS */
#define M_SEMILAND	bit(14) /* can land 1/4 */
/* M_XLIGHT will be automatically set in init_global() if m_nxlight > 0 */
#define	M_XLIGHT	bit(15)	/* can hold xlight planes */
/* M_CHOPPER will be automatically set in init_global() if m_nchoppers > 0 */
#define M_CHOPPER	bit(16)	/* can hold choppers */
#define M_OILER		bit(17)	/* can re-fuel ships */
#define M_SUPPLY	bit(18)	/* Can supply units/sects/ships */
/* M_XUNIT will be automatically set in init_global() if m_nland > 0 */
#define M_UNIT		bit(19)	/* Can carry units */
#define M_ANTIMISSILE   bit(20) /* Shoot down missile */ 

#define getship(n, p) \
	ef_read(EF_SHIP, n, (caddr_t)p)
#define putship(n, p) \
	ef_write(EF_SHIP, n, (caddr_t)p)
#define getshipp(n) \
	(struct shpstr *) ef_ptr(EF_SHIP, n)

extern	double seagun();

extern  struct mchrstr mchr[];
extern	int shp_maxno;

struct mlist {
	struct qelem queue;	/* list of ships */
	struct mchrstr *mcp;	/* pointer to desc of ship */
	struct shpstr ship;	/* struct ship */
	double mobil;           /* how much mobility the ship has left */
};

void shp_sel();
void shp_nav();
void shp_mess();
void shp_sweep();
int shp_check_mines();
int shp_interdict();
int shp_check_nav();
s_char *shp_path();
s_char *prship();
 /* return codes from shp_check_nav */
#define CN_NAVIGABLE	(0)
#define CN_LANDLOCKED	(1)
#define CN_CONSTRUCTION	(2)
#define CN_ERROR	(-1)

#endif /* _SHIP_H_ */
