#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/acce.c,v 2.2 1995/10/11 03:02:33 empire Exp $";
#endif /* not lint */

/*
 * acce.c
 *
 * hacked from rela.c
 *
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "nat.h"
#include "sect.h"
#include "file.h"
#include "xy.h"


/*
 * report rejection status of telegrams and treaties.
 * Optional argument reports staus from the
 * viewpoint of another country
 */
int
acce()
{
	struct	natstr *natp;
	struct	natstr *np;
	natid	cn;
	natid	as;
	int	n;

	if (player->argp[1] == 0)
		as = player->cnum;
	else {
		if ((n = natarg(player->argp[1], "Which country? ")) <= 0) {
			pr("Bad country number\n");
			return RET_SYN;
		}
		as = (natid) n;
	}
	if ((natp = getnatp(as)) == 0) {
		pr("Bad country number %d\n", player->cnum);
		return RET_SYN;
	}
	pr("\t%s Acceptance Status Report\t", cname(as));
	prdate();
	pr("\n  Acceptance status          %5s                theirs\n",
			player->cnum == as ? "yours" : " his");
	pr("                       tel trty anno loan   tel trty anno loan\n");
	for (cn=1; cn < MAXNOC; cn++) {
		if ((np = getnatp(cn)) == 0)
			break;
		if (cn == as)
			continue;
		if ((np->nat_stat & STAT_NORM) == 0 &&
		    (np->nat_stat & STAT_SANCT) == 0)
			continue;
#ifdef HIDDEN
		if (!player->god && !getcontact(getnatp(player->cnum), cn))
			continue;
#endif /* HIDDEN */
		pr("%3d) %-14.14s  ", cn, cname(cn));
		pr("%-9s %s\n", rejectname(natp, cn), rejectname(np, as));
	}
	return RET_OK;
}
