#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/gen/disassoc.c,v 2.1 1995/10/11 02:55:05 empire Exp $";
#endif

/*
 * disassoc.c
 *
 * boilerplate daemon code; disassociate from
 * the current tty by forking, closing all file
 * descriptors, opening slash, and ioctl-ing
 * TIOCNOTTY
 */

#include <sys/types.h>
#include <sys/ioctl.h>
#include <fcntl.h>

disassoc()
{
	int	i;

	if (fork() != 0)
		exit(0);
	for (i = 0; i < 10; i++)
		(void) close(i);
	(void) open("/", O_RDONLY, 0);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
#if defined hpux || defined SVR4
	setsid();
#else
	i = open("/dev/tty", O_RDWR, 0);
	if (i > 0) {
		(void) ioctl(i, TIOCNOTTY, 0);
		(void) close(i);
	}
#endif
}
