#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/common/bridgefall.c,v 2.0 1995/02/07 05:20:05 empire Exp $";
#endif

/*
 * bridgefall.c
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "path.h"
#include "file.h"
#include "xy.h"
#include "plane.h"
#include "land.h"
#include "nsc.h"

bridgefall(sp)
	struct	sctstr *sp;
{
	register int i;
	register int j;
	struct	sctstr sect;
	struct	sctstr bh_sect;
	int	nx;
	int	ny;
	int	nnx;
	int	nny;
	int	mines;
	register struct plnstr *pp;
	int	n;
	struct	plnstr p;

	for (i = 1; i <= 6; i++) {
		nx = sp->sct_x + diroff[i][0];
		ny = sp->sct_y + diroff[i][1];
		getsect(nx, ny, &sect);
		if (sect.sct_type != SCT_BSPAN)
			continue;
		for (j = 1; j <= 6; j++) {
			nnx = nx + diroff[j][0];
			nny = ny + diroff[j][1];
			if (nnx == sp->sct_x && nny == sp->sct_y)
				continue;
			getsect(nnx, nny, &bh_sect);
 			if (bh_sect.sct_type == SCT_BHEAD &&
			    bh_sect.sct_newtype == SCT_BHEAD)
				break;
		}
		if (j > 6) {
			struct lndstr land;

			wu(0, sect.sct_own,
				"Crumble... SCREEEECH!  Splash! at %s\n",
				xyas(sect.sct_x, sect.sct_y, sect.sct_own));
			sect.sct_type = SCT_WATER;
			sect.sct_newtype = SCT_WATER;
			sect.sct_own = 0;
			sect.sct_oldown = 0;
			pp = &p;
			for (n=0; ef_read(EF_PLANE, n, (s_char *)pp); n++) {
				if(pp->pln_x != sect.sct_x
				|| pp->pln_y != sect.sct_y)
					continue;
				pp->pln_own = 0;
				putplane(n, pp);
			}
			for (n=0; ef_read(EF_LAND, n, (s_char *)&land); n++) {
				if(land.lnd_x != sect.sct_x
				|| land.lnd_y != sect.sct_y)
					continue;
filelogerror("Bridgefall: land unit %d dies\n",land.lnd_uid);
				land.lnd_own = 0;
				putland(n, (s_char *)&land);
			}
			/*
			 * save only the mines; zero the rest of the
			 * commodities.
			 */
			mines = getvar(V_MINE, (caddr_t)&sect, EF_SECTOR);
			sect.sct_nv = 0;
			if (mines > 0)
				(void) putvar(V_MINE, mines, (caddr_t)&sect,
					EF_SECTOR);
			(void) putsect(&sect);
		}
	}
}
