#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/commands/cens.c,v 2.2 1995/10/11 03:02:33 empire Exp $";
#endif /* not lint */

/*
 * cens.c
 *
 * do a census report
 *
 * from PSL Empire, 1985
 */

#include "misc.h"
#include "player.h"
#include "var.h"
#include "xy.h"
#include "sect.h"
#include "nsc.h"
#include "nat.h"
#include "deity.h"
#include "path.h"
#include "file.h"

static	cens_hdr();

cens()
{
	struct	sctstr sect;
	int	nsect;
	int	n;
	struct	nstr_sect nstr;
	s_char	dirstr[20];
	int	vec[I_MAX+1];

	if (!snxtsct(&nstr, player->argp[1]))
		return RET_SYN;
	prdate();
	for (n = 1; n <= 6; n++)
		dirstr[n] = dirch[n];
	dirstr[0] = '.';
	dirstr[7] = '$';
	dirstr[8] = '\0';
	nsect = 0;
	while (nxtsct(&nstr, &sect)) {
		if (!player->owner)
			continue;
		if (nsect++ == 0)
			cens_hdr();
		if (player->god)
			pr("%3d ", sect.sct_own);
		prxy("%4d,%-4d", nstr.x, nstr.y, player->cnum);
		pr(" %c", dchr[sect.sct_type].d_mnem);
		if (sect.sct_newtype != sect.sct_type)
			pr("%c", dchr[sect.sct_newtype].d_mnem);
		else
			pr(" ");
		pr("%4d%%", sect.sct_effic);
		if (sect.sct_off)
			pr(" no ");
		else
			pr("    ");
		pr("%4d", sect.sct_mobil);

		getvec(VT_DEL, vec, (s_char *)&sect, EF_SECTOR);
		pr(" %c", dirstr[vec[I_UW] & 0x7]);
		pr("%c", dirstr[vec[I_FOOD] & 0x7]);

		getvec(VT_DIST, vec, (s_char *)&sect, EF_SECTOR);
		n = vec[I_UW] % 1000;
		pr(" %c", n == 0 ? '.' : '0'+ (n/100));
		n = vec[I_FOOD] % 1000;
		pr("%c ", n == 0 ? '.' : '0'+ (n/100));
		pr("%c", sect.sct_own != sect.sct_oldown ? '*' : ' ');

		getvec(VT_ITEM, vec, (s_char *)&sect, EF_SECTOR);
		pr("%5d", vec[I_CIVIL]);
		pr("%5d", vec[I_MILIT]);
		pr("%5d", vec[I_UW]);
		pr("%5d", vec[I_FOOD]);
		pr("%4d%%", sect.sct_work);
		pr("%5d", sect.sct_avail);
		if (!player->god)
			if (sect.sct_terr)
				pr("%4d", sect.sct_terr);
			else
				pr("    ");
#ifdef	FALLOUT
		getvec(VT_COND, vec, (void *)&sect, EF_SECTOR);
		pr("%4d",vec[C_FALLOUT]);
#endif	/* FALLOUT */
		set_coastal(&sect);
		if (sect.sct_coastal)
			pr("%5d", sect.sct_coastal);
		pr("\n");
	}
	if (nsect == 0) {
		if (player->argp[1])
			pr("%s: No sector(s)\n", player->argp[1]);
		else
			pr("%s: No sector(s)\n", "");
		return RET_FAIL;
	}else
		pr("%d sector%s\n", nsect, splur(nsect));
	return 0;
}

static
cens_hdr()
{
	if (player->god)
		pr("    ");
	pr("CENSUS                   del dst\n");
	if (player->god)
		pr("own ");
	pr("  sect        eff ");
	pr("prd ");
	pr("mob uf uf *  civ  mil   uw food work avail ");
	if (!player->god)
		pr("ter ");
#ifdef	FALLOUT
	pr("fallout ");
#endif	/* FALLOUT */
	pr("coast");
	pr("\n");
}

static
set_coastal(sp)
	struct	sctstr	*sp;
{
	int	n;
	struct	sctstr	sect;
	u_char	start_flags = sp->sct_coastal;

	for (n = 1; n <= 6; ++n) {	/* Directions */
		getsect(sp->sct_x + diroff[n][0],
			sp->sct_y + diroff[n][1],
			&sect);
		if (sect.sct_type == SCT_WATER) {
			sp->sct_coastal = 1;
			if (start_flags != sp->sct_coastal)
				putsect(sp);
			return;
		}
	}
	sp->sct_coastal = 0;
	if (start_flags != sp->sct_coastal)
		putsect(sp);
}
