.TH Introduction "Advice for Novices"
.NA Novice "Advice for Novices"
.LV Basic
.ce 3
.s1
\*(iFA Preface\*(pF
by Ken Stevens
.s1
While most of this document applies to the game of Empire in its
current form, it is important to keep in mind that the sections which
follow this preface were written long before missions or land units
were introduced into the game.  The main impact that missions and land
units have had on the game is that they greatly strengthened the
defense.  Here are "ten easy steps" for setting up a strong defense in
the new server:
.NF
(1) Build 100% forts and put 10 guns and at least 100 shells in them.
(2) Put at least 5 mil in all of your coastal sectors.
(3) Build infantry units, put them in the forts, "fortify" them, and
    put them on "reserve" mission (info mission).
(4) Build battleships and artillery and put them on "interdiction"
    mission.  Put the artillery in forts and fortify them.
(5) Put infantry units in your banks and capitals, fortify them, and set their
    reaction radius to 0 (info lrange).

---later in the game---

(6) Put lots of land mines in your ground (info lmine).
(7) Build fighter planes.
(8) Always guard your ships with destroyers (or other kinds of ASW ships).
(9) Build some ASW planes and put them on interdiction mission.
(10) Build lots of sam's and abm's.
.FI
.s1
\*(iFA Treatise of Advice on War and Peace
for Budding Empire Players\*(pF
by Dave Pare
.s1
This article contains advice for beginning players.
It deals mainly with staying alive and not economic development,
because staying alive is tougher for beginners
than is playing with the various Sector-types.
.s1
The most important thing I can say is that beginners should remember
that Empire is not realistic.
There are dozens of \*Qtricks\*U to learn;
until you master them, you will lose because of small oversights
Beware of patterning your Empire actions after real-world strategies;
they may not work as expected.
.s1
When you start, grab as much land as possible.
Locate and identify other players,
and get an idea of the size of your land mass.
Send them all telegrams.
Everybody likes to get telegrams;
the telegram facility gives you the chance to make friends,
influence people, and have fun role-playing your country.
If you get to know somebody,
you may not be attacked because you come across as a nice guy.
Of course, if you sound like a bozo, you may get stepped on.
.s1
Establish a definite border with your neighbors by inhabiting
sectors with one civilian.
This establishes your claim
to the land behind these outposts,
even though you don't actually occupy it yet.
It also prevents your neighbor from discovering where YOUR capital is.
In Empire, it's very important to protect the location of your capital;
likewise, it's quite nice to know the location
of the neighboring capitals \*Qjust in case\*U!
.s1
If any of your neighbors attacks your outposts,
that gives you a valuable clue to their intentions,
while not costing you much in the way of resources.
Also, an attack on a remote outpost may give you enough time
to prepare your country for the possible invasion to follow.
You may not want to claim too much land though,
or the outposts will get overrun by people
who are fed up with your obvious land-grabbing.
.s1
Basically, try and be fair about land distribution,
but make sure you get a good deal for yourself.
.s1
Empire players go to war for many reasons.
One is lack of resources;
you have land, and they want it.
Another is safety;
your troops or ships are perceived as menacing,
so they are destroyed by your adversary.
Another is because the attacking player
really enjoys attacking people!
Still another is boredom and/or curiosity --
\*QJust how do nukes work anyway?
Hey, I know, I'll try them out on Freedonia!\*U
.s1
In Empire, wars are generally won by people who attack first.
Because mobility can be saved up
your attacks can proceed while the hapless enemy is asleep.
Many Empire attacks have happened over the weekend,
or at 2:00 in the morning.
It is quite difficult to defend your country when you're not logged in.
The auto-defense features of the game are minimal at best.
.s1
The whole philosophy of \*QFirst Strike\*U holds true from early land
warfare, to naval warfare, to the philosophy of Mutual Assured
Destruction.
If you strike first and your attack is well-planned,
any retributive strike of the enemy's will be ragged at best.
If it's a land war,
all of the fighting will be on the enemy's territory,
not on yours.
Your industries will be fine, and the battleground will be the enemy's.
.s1
Having mentioned the advantages of pre-emptive strikes,
I must caution against spur-of-the-moment attacks.
I've noticed that many wars tend to occur because
some country sinks your battleship;
you get mad and decide to attack.
I'm just as guilty of this as anyone.
Spending a few days marshaling your forces
can mean the difference between a long, drawn-out slugfest,
and an overwhelming 2:00 blitzkrieg
that blows away half the enemy's army and navy
within the first few hours.
While it's nice to have instant gratification
(seeing enemy troops die right after you read the telegram
describing the destruction of your poor, defenseless battleship
feels SO good),
a hasty counterattack will alert your enemy
who will mobilize forces and retaliate accordingly.
Things will escalate, and you'll be in a full-scale shooting war
before you can say \*QGulf of Tonkin Resolution!\*U
And you will have lost the advantage.
.s1
Going first only counts if you have marshaled your forces.
A scattered, ill-planned attack will net you nothing
but a little instant gratification,
at the cost of a long drawn-out war in which
your neighbors who aren't fighting are the only winners.
Once two countries are at war,
it's much harder to win \*Qovernight\*U.
Vietnam is a good example of what you shouldn't do.
Gradual escalation just gives the enemy time to prepare.
A sudden, overwhelming attack is far better
and will achieve your goals much more cheaply.
.s1
Knowing where the enemy is located is absolutely critical
to the planning of a successful attack.
.s1
War takes up a lot of resources;
your personal time is the most precious resource of all.
In a war, your time, energy, and creativity will be devoted
towards destroying your adversary.
This leaves little time for economic development.
In war, the home front stagnates, or goes to seed.
Only the bare necessities are produced for the civilians at home,
technological innovation and new land development ceases,
and your country will generally fall behind in the global race
for technology.
.s1
Therefore, if you decide to go to war,
you'd better win quickly
or else it will take a lot of time,
and your country will go downhill fast.
If you're just punishing someone for doing something \*Qnasty\*U,
offer \*Qnice\*U peace terms after you've meted out
appropriate punishment.
If you aren't attacking because you're bored,
other players are likely to agree to peace
because losing a war is unpleasant.
I've turned enemies into allies often enough;
they are happy to survive,
and if your attack was relatively justified,
they are happy to have you as a friend.
.s1
You'll notice I didn't give any advice to responding to an attack.
I think being attacked is generally a losing proposition
because in Empire the attacker generally has the advantage
unless fighting with greatly lower tech equipment.
.s1
As soon as ships start appearing on the power chart,
make sure each sector bordering water
has at least five to ten military.
When more ships come around, beef up the coastline defenses even more.
Put tons of military in your capital.
.s1
To summarize,
if you go to war, strike the first blow -- preferably at 0200.
.s1
Remember the cost in your own personal time investment.
Once the ball starts rolling,
you won't be able to call it all off and go for a vacation.
Your enemy will want to kill you,
so you'd better be prepared to spend plenty of time in solid play.
.s1
.ce 3
\*(iFHumble Additions to the
Treatise of Advice\*(pF
by Tom Tedrick
.s1
In addition, keep mobility in mind.
In many of my low-tech wars, superior mobility was decisive.
.s1
Combining these ideas gives you my basic opening strategy:
take as many sectors as is possible, as quickly as possible
(I will take 300 sectors the first day if I can),
and designate them highways, leaving one civilian in each sector.
(You may need to leave one food in sectors with zero fertility.)
.s1
When my country first reaches 100% efficiency,
roughly two-thirds of my sectors will be 100% efficient highways.
This allows me to shift my forces all the way
from one border to another in a single move.
I once had great fun smashing three countries
that attacked me simultaneously from three sides
by shifting all my forces from border to border to border,
achieving local superiority in each case,
and annihilating the enemy forces in turn at updates
(this is related to the theory of the
advantages of interior lines worked out by the Germans).
.s1
If the enemy runs out of mobility you can sometimes catch
the main invasion force helplessly immobilized on the front lines
and annihilate it.
.s1
.ce 2
\*(iFHints to the Wise\*(pF
by Shelley Louie
.s1
Since this is an advice note,
I'll refrain from being too specific about tactics.
You'll just have to learn them yourself.
.s1
Building the Perfect Beast: (Country Construction)
.in +0.3i
.s1
The first thing you want is land.
Lots of land.
A whole hell of a lot of land.
You should try to expand your country from the very beginning.
From there, you'll meet your neighbors who are doubtlessly 
doing the same thing you're doing.
Expanding wildly.
Now comes the first of a series of decisions you have to make.
Do you want to become a raging power-mad warmonger?
If you do, be sure to have built your army beyond the basic 100 troops.
The earlier in the game you find someone,
the easier it is to crush them into oblivion.
If you feel peaceful, see the diplomatic section of the text.
.s1
Another difficult decision is designating your sectors.
A good beginning mix is two mines per light construction and
heavy construction factory,
about 20% agribusinesses
(later dropping to 10%, 5%, or even none at all!),
and a few schools, research, parks, etc.
to fill up some of the other space.
The most important thing to have is a good transportation system 
in the form of your highways.
Anywhere from 20-40% of your country should be highways.
You'll find them infinitely useful
in moving food to a starving sector,
taking people to a new settlement,
or transporting troops to a local revolution, highways are vital!  
.s1
Another important consideration is \*Qdo you want really want to win?\*U
This implies the idea of competing
in terms of building technology and research,
and being able to get supplies to continue to produce
both of these vital products plus happiness,
a high (greater than 10) education, maintaining a military force, etc.
Winning means succeeding on all fronts.
I play to win, but find that I can't devote the time or effort
to winning, so I usually end up playing for the pure enjoyment
of the game.
Ask Tom [Tedrick] how many hours he puts into playing,
and you can figure that is what you're going to have to do to win.
A final warning, if you play seriously, your grades will drop.
No if's, and's, or but's about this.
You can't just throw three to five hours a day away
and not have your schoolwork suffer.
.in
.s1
Happiness is a Warm Gun: (The Art of Diplomacy)
.in +0.3i
.s1
No one trusts anybody in this game unless you know them personally
outside of the limited scope of Empire.
Of course, this limits you a lot,
so you break the rules and make alliances
with people who you have no relation to.
And they in turn backstab you and devastate the country
you so meticulously built for the last few weeks.
Oh well, that's what you deserve...
.s1
Just kidding.
Most of the people you will play with are rather trustworthy souls.
At least they are until it becomes burdensome to them.
A good relationship (as all those sex manuals will tell you)
is based on trust and respect for the other person.
What does this mean to you?
Build enough military to be a pain to invade.
Military power insures respect.
Trust is up to the two people involved.
.in
.s1
Night Moves: (The Art of Empire)
.in +0.3i
.s1
Empire is a skill.
Never forget that.
You will learn as you play that you may have to stay up
for that 3:00 AM update to completely surprise your unknowing victim
or even just to maximize your country's potential.
Also never forget that someone may be up at that time
waiting to pounce all over you too.
Pleasant dreams.
.in
.s1
Running on Empty: (Losing and still having fun)
.in +0.3i
.s1
Okay, you've tried to keep up with Tom [Tedrick], Chris [Guthrie],
and all those other experienced people,
but it just isn't going to  happen.
You are not going to win the big win (i.e., become world dictator).
What do you do?
Give up and watch your country go to pot?
Give all your stuff away to another country and resign?
.s1
No!
You can have fun even after you can't win.
Make small wars with other small countries.
Try to get a hold of nukes to devastate them.
Form a cartel with other small nations
and try to run over a big country.
As in real life, the possibilities are endless!
Look at the Middle East, they're having fun, right? 
.s1
This is just a game, and from this point on,
you don't have to worry about watching over your nation too closely.
Play for the enjoyment of playing.
.s1
Which, of course, is the intention of Empire in the first place.
.in
.s1
.ce 2
\*(iFOn the Distribution of All Things\*(pF
by David Bleckmann
.s1
The reader here is assumed to have read the information pages
on distribute, threshold, and level.
.s1
To use distribute, it is a good idea to have a warehouse.
You don't have to, but this is how the command usually works.
If for some odd reason you don't use a warehouse,
you will have to use some other sector as your
\*Qdestination sector\*U, as mentioned in \*Qinfo level\*U.
For novices, just build a warehouse.
I will refer to warehouse instead of distribution sector
for the rest of this text.
.s1
You should place your warehouse in a spot
that can be reached by all your sectors via a low mobility path.
That is, for each sector you own,
there should be a path along which you could move goods
at very little mobility cost.
Since 100% efficient highways don't cost any mobility to move across,
roads that come close to each of your sectors
and lead to your warehouse are a good idea.
.s1
Now for each of your sectors you must set up a distribution path.
Use the distribute command.
This is a path from each of your sectors to your warehouse,
along a low mobility path as described above.
For example, if you have a nation that looks like this:
.NF
	  j j m + c
         m + g * +
	  h + w + k
	   m + + g
.FI
And you wanted to set up a path from your capital,
you would give the command
.EX dist 0,0 bbg
.s1
Note: the path can only be so long,
and as your country gets larger you will
need more than one warehouse.
.s1
Once you have done this for all of your sectors,
you are ready to start distributing.
.s1
Now you will probably want to have food on all your sectors,
and if one sector has a lot of people on it,
you may want to have a bit more on it.
You will not want to have to monitor the food levels
for all of your sectors.
This is the process that is automated by distribute.
.s1
Using food as an example,
you can go through all of your sectors and issue a threshold command,
such as:
.EX thresh f 0,0 40
.s1
This will set the threshold for food at your capital at 40.
You can do this for all of your sectors using a command like
.EX thresh f #
.s1
And give a threshold for each of your sectors as prompted.
.s1
Now at each update,
Empire will move food to and from your warehouse 
in an attempt to satisfy all your threshold requirements.
If for example a certain sector
has more than its allotted threshold of a certain product
(e.g., an agribusiness producing food),
food will be moved off it to the warehouse.
If a sector has less than its threshold,
and the warehouse has any of that commodity,
the product will be moved from the warehouse
to the needy sector in an attempt to satisfy its threshold.
If a certain sector has a threshold of 0 for a certain product,
no distribution takes place.
.s1
Therefore if you wished to move as much iron as possible
from an iron mine every update,
you would set its threshold for iron to one.
If somewhere else you had a lcm factory that can use 45 iron a turn
(found out through the prod command)
you would set its threshold for iron to 45 (or greater)
and its threshold for lcm's to one.
Then, on each update,
Empire would move all iron off your iron mine (except for one unit),
try to put 45 iron on your lcm factory and take all lcm's
(except for one)
off your lcm plant
(possibly to be used somewhere else).  
.s1
Note: the order in which this happens is predictable,
but not always desirable.
Thus, if you have no iron on your warehouse to start with
and your lcm factory gets updated first,
it won't get any iron even though there will be some in the warehouse
in a few seconds.
It is always a good idea to keep surplus goods in your warehouse.
.s1
The end result is that you can set up your country to move your products
around without you logging in.
It also doesn't cost as many mobility points
to move things as distribute, and it costs no BTU's!
.s1
.ce 3
\*(iFSome Further Clarifications
on Distribution versus Delivery\*(pF
by David Muir Sharnoff
.s1
.in +0.3i
\*(iFSecondly, I am still a little confused
about distribution and delivery.
When I designate a distribution route,
does that mean that things will be delivered
from the point of distribution to the warehouse?
Or do I also have add the delivery route
on top of the distribution route in order to get things moving?
And how do I get the visual route of the distribution route?
I can get delivery routes by doing the route command.
Thanks.\*(pF
.in
.s1
The two methods of moving commodities
(distribute/threshold/level and deliver/cutoff/route)
are completely independent.
.s1
Delivery is most useful for short, one-sector, movement of commodities.
Distribute can be used in conjunction with highways and distribution
sectors to provide low-cost, long-range movement of commodities.
There is no analog to the route command in the distribute paradigm.
.s1
Here are some examples of commands:
.s1
.EX distribute -2,0 jjjh
This command sets up a distribution path from the distribution sector
in -2,0 to sector 4,0.
.s1
.EX thresh food 4,0 400
This command sets the threshold on sector 4,0.
Sector -2,0 (the distribution sector for 4,0)
will attempt to keep 400 units of food in 4,0
by importing or exporting as necessary.
.s1
.EX thresh oil 4,0 100 
This command is the same as above,
but will instead attempt to keep 100 units of oil.
.s1
.EX level -2,0
This command will report the distribution routes
and thresholds for sector -2,0.
.s1
.EX deliver food -2,0 (384) y
This command will deliver all food from -2,0
in excess of 384 units to -3,-1.
.s1
.EX deliver lcm -2,0 b
This command will deliver all lcm's from -2,0 to -3,1.
.s1
.EX deliver lcm -2,0 +30
This command will deliver lcm's in excess of 24
(deliver uses multiples of eight).
.s1
.EX cutoff -2,0
This command will report what commodities are being delivered
from -2,0 and what their cutoffs are.
.s1
.EX route food -20:20,-10:10
This command will graphically report the food delivery paths
in the sectors from -20:20 to -10:10.
.s1
.ce 2
\*(iFSome More Hints for the Novice\*(pF
by Jeff Trim
.s1
Tech levels are very important in this game.
You cannot produce uranium, guns or shells
until you achieve a tech level of 40.
.s1
Choose your friends carefully.
I was talking to Lewis from Cornell College
and his comment was the best I'd heard in a while:
\*QNever ally with someone that doesn't have a definite
interest in seeing you survive.\*U
Don't be deceived by the treaty command;
treaty violations will show up in the news,
but that is not going to stop the aggressor from wiping you out,
no matter how bad it looks in the news.
.s1
Nuclear attacks can cause a lot of damage,
but no one has ever been taken out of the game by a nuclear attack.
The damage from a purely nuclear attack is recoverable.
It takes conventional forces combined with nukes to really do damage.
(Of course I won't fool you either;
it doesn't hurt to have a few nukes either.)
.s1
Beware of running low on BTU's.
I will recount one story of a player on this site
that was running low on BTU's.
His enemies launched a nuclear attack and hit his capital!
Unfortunately, he didn't have enough BTU's
to redesignate a new capital.
The moral of the story is that you should
plan an alternate capital at some point in the game.
These are generally not needed at the beginning of the game,
because you need to effectively deploy your sectors in the early going.
But later, it wouldn't hurt to have one or more alternate capitals.
.s1
Empire is a game of perception.
If your adversaries think you're tough,
they're probably going to pass you and head for easier prey.
But the reverse is also true;
if you look weak they might try a few tactics on you --
and depending upon your response,
they'll either back down or fight it out.
Bargain from a position of strength.
You could be the weakest country on the planet but still look
so tough that no one would bother you.
It's all perception.
.s1
Weak countries have an added advantage: gun running!
If a country is heading out with his fleet
to attack another country and you happen to be along the way,
you could cut a deal with him and
you could make a deal and allow that country to attack a coastal
sector and turn it into a harbor.
You've now placed an obligation on that country,
who will be very careful to keep you happy so you won't
grant similar privileges to that country's enemy.
Weak nations can be quite powerful if you handle the diplomacy right.
The tough players like blowing away their tough adversaries
and as long as you stand idly by
and watch those two countries blow each other to little pieces,
you'll be left intact and growing richer off their little war.
.s1
.ce
.s1
.SA "Overview, Hints, Expert, Introduction"
