#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/update/populace.c,v 2.0 1995/02/07 05:43:48 empire Exp $";
#endif

/*
 * populace.c
 *
 * return workforce available
 *
 * Dave Pare, 1986
 */

#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "news.h"
#include "var.h"
#include "file.h"
#include "path.h"
#include "xy.h"
#include "land.h"
#include "budg.h"

double
populace(np, sp, vec, etu)
	struct	natstr *np;
	register struct sctstr *sp;
	register int *vec;
	int	etu;
{
	extern	double money_mil, money_civ;
	extern 	double money_uw;
	float	taxes;
	float	hap;
	float	tech;
	float	edu;
	float	pct;
	int	n;

	if (vec[I_CIVIL] == 0 && vec[I_MILIT] > 0) {
		sp->sct_work = 100;
		sp->sct_loyal = 0;
		sp->sct_oldown = sp->sct_own;
	}
	if (!vec[I_CIVIL] && !vec[I_MILIT] && !vec[I_UW] &&
		!has_units(sp->sct_x,sp->sct_y,sp->sct_own)) {
		sp->sct_own = 0;
		sp->sct_oldown = 0;
		return 0.0;
	}
	if (sp->sct_own != sp->sct_oldown && sp->sct_loyal == 0) {
		sp->sct_oldown = sp->sct_own;
	}
	/*
	 * collect the taxes, and pay the troops
	 */
	
	taxes = (int) (civ_taxes(vec[I_CIVIL], sp->sct_effic) + uw_taxes(vec[I_UW], sp->sct_effic) + mil_payment(vec[I_MILIT]));
	np->nat_money += (int) taxes;
	hap = np->nat_level[NAT_HLEV];
	edu = np->nat_level[NAT_ELEV];
	tech = np->nat_level[NAT_TLEV];
	pct = (tech - 40) / 40.0 + edu / 3.0;
	if (sp->sct_own == sp->sct_oldown && hap < pct &&
	    chance((pct-hap)/5.0)) {
		/*
		 * zap the loyalty of unhappy civilians.
		 * there is a 20% chance per hap point below the
		 * "recommended" amount of this happening.
		 */
		n = sp->sct_loyal + (random() % 6) + 1;
		if (n > 127)
			n = 127;
		sp->sct_loyal = n;
	}
	if (sp->sct_loyal > 65 && vec[I_MILIT] < vec[I_CIVIL]/20) {
		int	work_red;

		work_red = sp->sct_loyal - (50 + (random() % 15));
		n = sp->sct_work - work_red;
		if (n < 0)
			n = 0;
		sp->sct_work = n;
		if (chance((double)work_red/1000.0)) {
			/*
			 * small chance of rebellion...
			 * if work_red is (max) 67,
			 * then revolt chance is 6.7%
			 */
			revolt(sp);
		} else if (chance(.30) && sp->sct_own)
			wu(0, sp->sct_own, "Civil unrest in %s!\n", ownxy(sp));
	}
	if (sp->sct_loyal) {
		n = sp->sct_loyal;
		if (chance(0.75))
			n -= roundavg(etu * 0.25);
		else
			n += roundavg(etu * 0.125);
		if (n < 0)
			n = 0;
		else if (n > 127)
			n = 127;
		sp->sct_loyal = n;
		if (sp->sct_loyal == 0) {
			if (sp->sct_oldown != sp->sct_own) {
				wu(0, sp->sct_own,
					"Sector %s is now fully yours\n",
					ownxy(sp));
				sp->sct_oldown = sp->sct_own;
			}
			sp->sct_loyal = 0;
		}
	}
	return (vec[I_CIVIL] * sp->sct_work) / 100.0 +
		(vec[I_MILIT] * 2 / 5.0) + vec[I_UW];
}

/*
 * percentage of people who starved
 */
int
starvation(sp)
	struct	sctstr *sp;
{
	sp->sct_work = 0;
	sp->sct_loyal += (random() % 8) + 2;
}

double
total_work(sp, vec)
register struct sctstr *sp;
register int *vec;
{
	return ((double)((vec[I_CIVIL] * sp->sct_work) / 100.0 +
		(vec[I_MILIT] * 2 / 5.0) + vec[I_UW]));
}
