#ifndef lint
static char *RCSid = "$Header: /usr/brule/guest/empire/empire/emprcs/lib/update/human.c,v 2.4 1995/08/16 05:51:24 empire Exp $";
#endif

/*
 * human.c
 *
 * Update the people in empire; food, plague, etc
 * 
 * from PSL Empire, 1985
 * and Dave Pare, 1986
 */

#include <math.h>
#include "misc.h"
#include "var.h"
#include "sect.h"
#include "nat.h"
#include "item.h"
#include "news.h"
#include "file.h"
#include "xy.h"
#include "optlist.h"

/*
 * Grow babies, and add to populace.
 * XXX Might think about dropping in a birth
 * rate limitation on countries with high tech
 * production?  Maybe with just high education?
 */
int grow_people(sp, etus, np, vec)
	struct	sctstr *sp;
	register int etus;
	register struct natstr *np;
	register int *vec;
{
	extern	double obrate;
	extern	double uwbrate;
	extern	double babyeat;
	int	newciv;
	int	newuw;
	int	new_birth;
	int	new_food;
	int	maxpop = max_pop(np->nat_level[NAT_RLEV], sp);

	newciv = 0;
	newuw = 0;
	if (vec[I_CIVIL] < maxpop) {
		new_birth = (int) roundavg(obrate * (double)(etus * vec[I_CIVIL]));
		if (opt_NOFOOD) 
			new_food = (int) (0.5 + maxpop / (2.0 * babyeat));
		else		/* we are using food */
			new_food = (int) (0.5 + vec[I_FOOD] / (2.0 * babyeat));

		newciv = new_birth;
		if (newciv > new_food)
			newciv = new_food;
		vec[I_CIVIL] += newciv;
	}
	if (vec[I_CIVIL] > maxpop)
		vec[I_CIVIL] = maxpop;
	if (vec[I_UW] < maxpop) {
		/*
		 * now grow uw's
		 */
		new_birth = (int) roundavg(uwbrate * (double)(etus * vec[I_UW]));
		if (opt_NOFOOD)
			new_food = (int) (0.5 + maxpop / (2.0 * babyeat));
		else		/* food is important */
			new_food = (int) (0.5 + vec[I_FOOD] / (2.0 * babyeat));

		newuw = new_birth;
		if (newuw > new_food)
			newuw = new_food;
		vec[I_UW] += newuw;
	}
	if (vec[I_UW] > maxpop)
		vec[I_UW] = maxpop;
	/*
	 * subtract the baby eat food (if we are using FOOD) and return
	 * # of births.
	 */
	if (opt_NOFOOD == 0 && (newciv || newuw))
		vec[I_FOOD] -= roundavg((newciv + newuw) * babyeat);
	return newciv + newuw;
}

/*ARGSUSED*/
int
infect_people(np, vec, eff, mobil)
	struct	natstr *np;
	register int *vec;
	u_int	eff;
	int	mobil;
{
	double	plg_num;
	double	plg_denom;
	double	plg_chance;

	if (opt_NO_PLAGUE)	/* no plague nothing to do */
		return 0;

	if (np->nat_level[NAT_TLEV] <= 10.0)
		return 0;
	/*
	 * make plague where there was none before...
	 */
	plg_num = ((vec[I_CIVIL] + vec[I_MILIT] + vec[I_UW]) / 999.0) *
		((vec[I_IRON] + vec[I_OIL]) / 10.0 +
		np->nat_level[NAT_TLEV] + 100.0);
	plg_denom = eff + mobil + 100 + np->nat_level[NAT_RLEV];
	plg_chance = ((plg_num / plg_denom) - 1.0) * 0.01;
	if (chance(plg_chance))
		return PLG_EXPOSED;
	return 0;
}

/*
 * Given the fact that plague exists, kill off
 * people if in plague state DYING.  Increment
 * the plague time.  Return "current" plague
 * stage.  No reports generated here anymore.
 */
int
plague_people(np, vec, cvec, etus)
	struct	natstr *np;
	register int *vec;
	register int *cvec;
	int	etus;
{
	int	stage;
	double	plg_num;
	double	plg_denom;
	double	pct_left;

	cvec[C_PTIME] -= etus;
	stage = cvec[C_PSTAGE];
	switch (stage) {
	case PLG_DYING:
		plg_num = 100.0 * etus;
		plg_denom = (np->nat_level[NAT_RLEV] + 100.0) *
			(vec[C_PTIME] + etus + 1.0);
		pct_left = 1.0 - plg_num / plg_denom;
		if (pct_left < 0.2)
			pct_left = 0.2;
		vec[I_CIVIL] = vec[I_CIVIL] * pct_left;
		vec[I_MILIT] = vec[I_MILIT] * pct_left;
		vec[I_UW] = vec[I_UW] * pct_left;
		break;
	case PLG_INFECT:
	case PLG_INCUBATE:
		break;
	case PLG_EXPOSED:
		cvec[C_PTIME] = 0;
		break;
	default:
		/* bad */
		cvec[C_PTIME] = 0;
		break;
	}
	if (cvec[C_PTIME] <= 0) {
		cvec[C_PSTAGE]--;
		cvec[C_PTIME] = 32 + (random() % 32);
	}
	return stage;
}
